% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_density.R
\name{gg_density_facet}
\alias{gg_density_facet}
\title{Smoothed density ggplot that is facetted.}
\usage{
gg_density_facet(data, x_var, facet_var, density_bw = "nrd0",
  density_adjust = 1, density_kernel = "gaussian", density_n = 512,
  density_trim = FALSE, pal = NULL, alpha = 0.1, size_line = 0.5,
  title = NULL, title_wrap = 80, subtitle = NULL,
  subtitle_wrap = 80, x_balance = FALSE, x_expand = NULL,
  x_labels = NULL, x_pretty_n = 3, x_title = NULL,
  x_title_wrap = 50, x_zero = FALSE, x_zero_line = NULL,
  y_expand = NULL, y_gridlines_minor = FALSE,
  y_labels = scales::number, y_pretty_n = 4, y_title = NULL,
  y_title_wrap = 50, facet_labels = stringr::str_to_sentence,
  facet_na = TRUE, facet_ncol = NULL, facet_nrow = NULL,
  facet_scales = "fixed", caption = NULL, caption_wrap = 80,
  font_family = "", font_size_title = NULL, font_size_body = NULL)
}
\arguments{
\item{data}{A tibble or dataframe. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x scale. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{density_bw}{The bw argument of the stats::density function. Defaults to "nrd0".}

\item{density_adjust}{The adjust argument of the stats::density function. Defaults to 1.}

\item{density_kernel}{The kernel argument of the stats::density function. Defaults to "gaussian".}

\item{density_n}{The n argument of the stats::density function. Defaults to 512.}

\item{density_trim}{The trim argument of the stats::density function. Defaults to FALSE.}

\item{pal}{Character vector of hex codes.}

\item{alpha}{The alpha of the fill. Defaults to 1.}

\item{size_line}{The size of the outlines of density areas.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 75.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 75.}

\item{x_balance}{For a numeric x variable, add balance to the x scale so that zero is in the centre. Defaults to FALSE.}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_labels}{A function or named vector to modify x scale labels. If NULL, categorical variable labels are converted to sentence case. Use ggplot2::waiver() to keep x labels untransformed.}

\item{x_pretty_n}{For a numeric x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 3.}

\item{x_title}{X scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{x_zero}{For a numeric x variable, TRUE or FALSE of whether the minimum of the x scale is zero. Defaults to FALSE.}

\item{x_zero_line}{For a numeric x variable, TRUE or FALSE of whether to add a zero reference line to the x scale. Defaults to TRUE if there are positive and negative values in x_var. Otherwise defaults to FALSE.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_gridlines_minor}{TRUE or FALSE of whether to add minor gridlines to the y scale. Defaults to FALSE.}

\item{y_labels}{A function or named vector to modify y scale labels. If NULL, categorical variable labels are converted to sentence case. Use ggplot2::waiver() to keep y labels untransformed.}

\item{y_pretty_n}{For a numeric y variable, the desired number of intervals on the y scale, as calculated by the pretty algorithm. Defaults to 4.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{facet_labels}{A function or named vector to modify facet scale labels. Defaults to converting labels to sentence case. Use ggplot2::waiver() to keep facet labels untransformed.}

\item{facet_na}{TRUE or FALSE of whether to include facet_var NA values. Defaults to TRUE.}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{font_family}{Font family to use. Defaults to "".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}
}
\value{
A ggplot object.
}
\description{
Smoothed density ggplot that is facetted, but not coloured.
}
\examples{
library(simplevis)
library(palmerpenguins)

gg_density_facet(penguins, 
                 x_var = body_mass_g, 
                 facet_var = species, 
                 x_pretty_n = 2)

}
