% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet_stars_fun.R
\name{leaflet_stars_col}
\alias{leaflet_stars_col}
\title{Map of an array in leaflet that is coloured.}
\usage{
leaflet_stars_col(data, col_method = "quantile", quantile_cuts = c(0,
  0.25, 0.5, 0.75, 1), bin_cuts = NULL, pal = NULL, rev_pal = FALSE,
  opacity = 1, legend_digits = 1, title = "[Title]",
  legend_labels = NULL, basemap = "light", shiny = FALSE,
  map_id = "map")
}
\arguments{
\item{data}{A stars object with dimensions x and y, and 1 attribute layer with crs in wgs84 (epsg4326). Required input.}

\item{col_method}{The method of colouring features, either "bin", "quantile" or "category." Defaults to "quantile". Note all numeric variables are cut to be inclusive of the min in the range, and exclusive of the max in the range (except for the final bucket which includes the highest value).}

\item{quantile_cuts}{A vector of probability cuts applicable where col_method of "quantile" is selected. The first number in the vector should 0 and the final number 1. Defaults to quartiles. Only applicable where col_method equals "quantile".}

\item{bin_cuts}{A vector of bin cuts applicable where col_method of "bin" is selected. The first number in the vector should be either -Inf or 0, and the final number Inf. If NULL, 'pretty' breaks are used. Only applicable where col_method equals "bin".}

\item{pal}{Character vector of hex codes, or provided objects with pal_ prefixes. Defaults to viridis.}

\item{rev_pal}{Reverses the palette. Defaults to FALSE.}

\item{opacity}{Sets the opacity of the grid cells. Defaults to 0.9.}

\item{legend_digits}{Select the appropriate number of decimal places for the auto legend. Defaults to 1.}

\item{title}{A title string that will be wrapped into the legend. Defaults to "Title".}

\item{legend_labels}{A vector of legend label values. Defaults to NULL, which results in automatic labels.}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{shiny}{TRUE or FALSE for whether the map is being run within a shiny app. Defaults to FALSE.}

\item{map_id}{This argument is only relevant for within apps. For single map shiny apps, the id "map" can be used. For dual map apps, "map1" and "map2" should be used. Defaults to "map".}
}
\value{
A leaflet object.
}
\description{
Map of an array in leaflet that is coloured.
}
\examples{
leaflet_stars_col(example_stars_nz_no3n, 
   col_method = "quantile", quantile_cuts = c(0, 0.05, 0.25, 0.5, 0.75, 0.95, 1),
   title = "River modelled median nitrate-nitrogen concentrations in g/m\\u00b3, 2013\\u201317")
}
