% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep.R
\name{get_ecd_values}
\alias{get_ecd_values}
\title{Get empirical cumulative distribution values of pval or prob_lower}
\usage{
get_ecd_values(df_sim_studies, df_sim_sites, val_str)
}
\arguments{
\item{df_sim_studies}{dataframe, generated by \code{\link[=sim_studies]{sim_studies()}}}

\item{df_sim_sites}{dataframe, generated by \code{\link[=sim_sites]{sim_sites()}}}

\item{val_str}{c("prob_low","pval")}
}
\value{
dataframe with the following columns:
\describe{
\item{\strong{study_id}}{study identification}
\item{\strong{site_number}}{site identification}
\item{\strong{visit_med75}}{median(max(visit)) * 0.75}
\item{\strong{mean_ae_site_med75}}{mean AE at visit_med75 site level}
\item{\strong{mean_ae_study_med75}}{mean AE at visit_med75 study level}
\item{\strong{{pval/prob_low}}}{p-value as returned by \code{poisson.test}}
\item{\strong{{pval/prob_low}_ecd}}{p-value as returned by \code{poisson.test}}
}
}
\description{
Test function, test applicability of poisson test, by calculating
\itemize{
\item the bootstrapped probability of obtaining a specific p-value or lower, use
in combination with \code{\link[=sim_studies]{sim_studies()}}.
}
}
\details{
trains a ecdf function for each studies based on the results
of \code{\link[=sim_studies]{sim_studies()}}
}
\examples{
df_visit <- sim_test_data_study(n_pat = 100, n_sites = 5,
    frac_site_with_ur = 0.4, ur_rate = 0.3)

df_visit$study_id <- "A"
df_site <- site_aggr(df_visit)

df_sim_sites <- sim_sites(df_site, df_visit, r = 100)

df_sim_studies <- sim_studies(
  df_site = df_site,
  df_visit = df_visit,
  r = 3,
  parallel = FALSE,
  poisson_test = TRUE,
  prob_lower = TRUE
)

get_ecd_values(df_sim_studies, df_sim_sites, "prob_low")
get_ecd_values(df_sim_studies, df_sim_sites, "pval")
}
