% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R, R/f7-tabs.R,
%   R/f7-validate-inputs.R, R/f7Messages.R, R/f7Navbar.R, R/f7Popover.R,
%   R/f7Preloader.R, R/manifest.R
\name{f7checkBox}
\alias{f7checkBox}
\alias{f7checkBoxGroup}
\alias{f7InsertTab}
\alias{f7RemoveTab}
\alias{f7ValidateInput}
\alias{f7AddMessages}
\alias{f7HideNavbar}
\alias{f7ShowNavbar}
\alias{f7Popover}
\alias{f7PopoverTarget}
\alias{f7ShowPreloader}
\alias{hideF7Preloader}
\alias{create_manifest}
\title{Deprecated functions}
\usage{
f7checkBox(inputId, label, value = FALSE)

f7checkBoxGroup(inputId, label, choices = NULL, selected = NULL)

f7InsertTab(
  id,
  tab,
  target,
  position = c("before", "after"),
  select = FALSE,
  session = shiny::getDefaultReactiveDomain()
)

f7RemoveTab(id, target, session = shiny::getDefaultReactiveDomain())

f7ValidateInput(
  inputId,
  info = NULL,
  pattern = NULL,
  error = NULL,
  session = shiny::getDefaultReactiveDomain()
)

f7AddMessages(
  id,
  messages,
  showTyping = FALSE,
  session = shiny::getDefaultReactiveDomain()
)

f7HideNavbar(
  animate = TRUE,
  hideStatusbar = FALSE,
  session = shiny::getDefaultReactiveDomain()
)

f7ShowNavbar(animate = TRUE, session = shiny::getDefaultReactiveDomain())

f7Popover(targetId, content, session = shiny::getDefaultReactiveDomain())

f7PopoverTarget(tag, targetId)

f7ShowPreloader(
  target = NULL,
  color = NULL,
  session = shiny::getDefaultReactiveDomain()
)

hideF7Preloader(target = NULL, session = shiny::getDefaultReactiveDomain())

create_manifest(
  path,
  name = "My App",
  shortName = "My App",
  description = "What it does!",
  lang = "en-US",
  startUrl,
  display = c("minimal-ui", "standalone", "fullscreen", "browser"),
  background_color = "#000000",
  theme_color = "#0000ffff",
  icon
)
}
\arguments{
\item{inputId}{Input to validate.}

\item{id}{\link{f7Tabs} id.}

\item{tab}{\link{f7Tab} to insert.}

\item{target}{\link{f7Tab} after of before which the new tab will be inserted.}

\item{position}{Insert before or after: \code{c("before", "after")}.}

\item{select}{Whether to select the newly inserted tab. FALSE by default.}

\item{session}{shiny session.}

\item{info}{Additional text to display below the input field.}

\item{pattern}{Pattern for validation. Regex.}

\item{error}{Error text.}

\item{messages}{List of \link{f7Messages}.}

\item{showTyping}{Show typing when a new message comes. Default to FALSE.
Does not work yet...}

\item{animate}{Whether it should be hidden with animation or not. By default is TRUE.}

\item{hideStatusbar}{When FALSE (default) it hides navbar partially keeping space
required to cover statusbar area. Otherwise, navbar will be fully hidden.}

\item{targetId}{Popover id. Must correspond to the \link{f7Popover} targetId.}

\item{content}{Popover content.}

\item{tag}{Tag that will be targeted. Must be a f7Input element.}

\item{color}{Preloader color.}

\item{path}{package path.}

\item{name}{App name.}

\item{shortName}{App short name.}

\item{description}{App description}

\item{lang}{App language (en-US by default).}

\item{startUrl}{Page to open at start.}

\item{display}{Display mode. Choose among \code{c("minimal-ui", "standalone", "fullscreen", "browser")}.
In practice, you want the standalone mode so that the app looks like a native app.}

\item{background_color}{The background_color property is used on the splash screen when the application is first launched.}

\item{theme_color}{The theme_color sets the color of the tool bar, and may be reflected in the app's preview in task switchers.}

\item{icon}{Dataframe containing icon specs. src gives the icon path
(in the www folder for instance), sizes gives the size and types the type.}
}
\value{
This function creates a www folder for your shiny app. Must specify the path.
It creates 1 folders to contain icons and the manifest.json file.
}
\description{
\code{f7checkBox} creates a checkbox input. Use \link{f7Checkbox} instead.

\code{f7checkBoxGroup} creates a checkbox group input.
Use \link{f7CheckboxGroup} instead

\code{removeF7Tab} removes an \link{f7Tab} in an \link{f7Tabs}.
Use \link{removeF7Tab} instead

\code{f7ValidateInput} validates a given shinyMobile input.
Use \link{validateF7Input} instead

\code{f7AddMessages} adds messages to an \link{f7Messages} container.
Use \link{updateF7Messages} instead

\code{f7HideNavbar} hides an \link{f7Navbar} component from the
server. Use \link{updateF7Navbar} instead.

\code{f7ShowNavbar} shows an \link{f7Navbar} component from the server.
Use \link{updateF7Navbar} instead.

\code{f7Popover} is deprecated. It has to be used in an oberve
or observeEvent context. Only works for input elements!

\code{f7PopoverTarget} is deprecated. This must be used in combination of \link{f7Popover}.
Only works for input elements!

\code{f7ShowPreloader} shows a preloader.
Use \link{showF7Preloader} instead

\code{hideF7Preloader} hides a preloader.
Use \link{f7HidePreloader} instead

\code{create_manifest} creates a manifest for your shiny App. Please use this workflow instead:
\url{https://unleash-shiny.rinterface.com/mobile-pwa.html#charpente-and-pwa-tools}.
}
\note{
See \url{https://developer.mozilla.org/en-US/docs/Web/Manifest} for more informations.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
    ui = f7Page(
       title = "Hide navbar",
       f7SingleLayout(
          navbar = f7Navbar("Hide/Show navbar"),
          f7Segment(
             f7Button(inputId = "hide", "Hide navbar", color = "red"),
             f7Button(inputId = "show", "Show navbar", color = "green"),
          )
       )
    ),
    server = function(input, output, session) {

       observeEvent(input$hide, {
          f7HideNavbar()
       })

       observeEvent(input$show, {
          f7ShowNavbar()
       })
    }
 )
}
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     title = "f7Popover",
     f7SingleLayout(
       navbar = f7Navbar(title = "f7Popover"),
       f7PopoverTarget(
         f7Button(
           inputId = "goButton",
           "Go!"
         ),
         targetId = "test"
       ),
       br(),
       br(),
       f7PopoverTarget(
         f7Slider(
           inputId = "slider",
           label = "Value",
           value = 10,
           min = 0,
           max = 20
         ),
         targetId = "test2"
       )
     )
   ),
   server = function(input, output, session) {
     observe({
       f7Popover(
         targetId = "test",
         content = "This is a f7Button"
       )
     })

     observe({
       f7Popover(
         targetId = "test2",
         content = "This is a f7Slider"
       )
     })
   }
 )
}
create_manifest(
  path = tempdir(),
  name = "My App",
  shortName = "My App",
  description = "What it does!",
  lang = "en-US",
  startUrl = "https://www.google.com/",
  display = "standalone",
  background_color = "#3367D6",
  theme_color = "#3367D6",
  icon = data.frame(
    src = "icons/128x128.png",
    sizes = "128x128", 10,
    types = "image/png"
  )
)
}
\keyword{internal}
