% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{vaeac_get_data_objects}
\alias{vaeac_get_data_objects}
\title{Function to set up data loaders and save file names}
\usage{
vaeac_get_data_objects(
  x_train,
  log_exp_cont_feat,
  val_ratio,
  batch_size,
  paired_sampling,
  model_description,
  depth,
  width,
  latent_dim,
  lr,
  epochs,
  save_every_nth_epoch,
  folder_to_save_model,
  train_indices = NULL,
  val_indices = NULL
)
}
\arguments{
\item{x_train}{A data.table containing the training data. Categorical data must have class names \eqn{1,2,\dots,K}.}

\item{log_exp_cont_feat}{Logical (default is \code{FALSE}). If we are to \eqn{\log} transform all
continuous features before sending the data to \code{\link[=vaeac]{vaeac()}}. The \code{vaeac} model creates unbounded Monte Carlo
sample values. Thus, if the continuous features are strictly positive (as for, e.g., the Burr distribution and
Abalone data set), it can be advantageous to \eqn{\log} transform the data to unbounded form before using \code{vaeac}.
If \code{TRUE}, then \code{\link[=vaeac_postprocess_data]{vaeac_postprocess_data()}} will take the \eqn{\exp} of the results to get back to strictly
positive values when using the \code{vaeac} model to impute missing values/generate the Monte Carlo samples.}

\item{val_ratio}{Numeric (default is \code{0.25}). Scalar between \code{0} and \code{1} indicating the ratio of
instances from the input data which will be used as validation data. That is, \code{val_ratio = 0.25} means
that \verb{75\%} of the provided data is used as training data, while the remaining \verb{25\%} is used as validation data.}

\item{batch_size}{Positive integer (default is \code{64}). The number of samples to include in each batch
during the training of the vaeac model. Used in \code{\link[torch:dataloader]{torch::dataloader()}}.}

\item{paired_sampling}{Logical (default is \code{TRUE}). If \code{TRUE}, we apply paired sampling to the training
batches. That is, the training observations in each batch will be duplicated, where the first instance will be masked
by \eqn{S} while the second instance will be masked by \eqn{\bar{S}}. This ensures that the training of the
\code{vaeac} model becomes more stable as the model has access to the full version of each training observation. However,
this will increase the training time due to more complex implementation and doubling the size of each batch. See
\code{\link[=paired_sampler]{paired_sampler()}} for more information.}

\item{model_description}{String (default is \code{make.names(Sys.time())}). String containing, e.g., the name of the
data distribution or additional parameter information. Used in the save name of the fitted model. If not provided,
then a name will be generated based on \code{\link[base:Sys.time]{base::Sys.time()}} to ensure a unique name. We use \code{\link[base:make.names]{base::make.names()}} to
ensure a valid file name for all operating systems.}

\item{depth}{Positive integer (default is \code{3}). The number of hidden layers
in the neural networks of the masked encoder, full encoder, and decoder.}

\item{width}{Positive integer (default is \code{32}). The number of neurons in each
hidden layer in the neural networks of the masked encoder, full encoder, and decoder.}

\item{latent_dim}{Positive integer (default is \code{8}). The number of dimensions in the latent space.}

\item{lr}{Positive numeric (default is \code{0.001}). The learning rate used in the \code{\link[torch:optim_adam]{torch::optim_adam()}} optimizer.}

\item{epochs}{Positive integer (default is \code{100}). The number of epochs to train the final vaeac model.
This includes \code{epochs_initiation_phase}, where the default is \code{2}.}

\item{save_every_nth_epoch}{Positive integer (default is \code{NULL}). If provided, then the vaeac model after
every \code{save_every_nth_epoch}th epoch will be saved.}

\item{folder_to_save_model}{String (default is \code{\link[base:tempfile]{base::tempdir()}}). String specifying a path to a folder where
the function is to save the fitted vaeac model. Note that  the path will be removed from the returned
\code{\link[=explain]{explain()}} object if \code{vaeac.save_model = FALSE}.}

\item{train_indices}{Numeric array (optional) containing the indices of the training observations.
There are conducted no checks to validate the indices.}

\item{val_indices}{Numeric array (optional) containing the indices of the validation observations.
#' There are conducted no checks to validate the indices.}
}
\value{
List of objects needed to train the \code{vaeac} model
}
\description{
Function to set up data loaders and save file names
}
\keyword{internal}
