% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{model_checker}
\alias{model_checker}
\alias{model_checker.default}
\alias{model_checker.lm}
\alias{model_checker.glm}
\alias{model_checker.ranger}
\alias{model_checker.gam}
\alias{model_checker.xgb.Booster}
\title{Check that the type of model is supported by the explanation method}
\usage{
model_checker(x)

\method{model_checker}{default}(x)

\method{model_checker}{lm}(x)

\method{model_checker}{glm}(x)

\method{model_checker}{ranger}(x)

\method{model_checker}{gam}(x)

\method{model_checker}{xgb.Booster}(x)
}
\arguments{
\item{x}{Model object for the model to be explained.}
}
\value{
Error or NULL
}
\description{
The function checks whether the model given by \code{x} is supported.
If \code{x} is not a supported model the function will return an error message, otherwise it return NULL
(meaning all types of models with this class is supported)
}
\details{
See \code{\link{predict_model}} for more information about
what type of models \code{shapr} currently support.
}
\examples{
if (requireNamespace("MASS", quietly = TRUE)) {
  # Load example data
  data("Boston", package = "MASS")
  # Split data into test- and training data
  x_train <- head(Boston, -3)
  # Fit a linear model
  model <- lm(medv ~ lstat + rm + dis + indus, data = x_train)

  # Checking the model object
  model_checker(x = model)
}
}
\keyword{internal}
