% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNPstats.R
\name{CalcChi2}
\alias{CalcChi2}
\title{Perform chi-square test on observed vs expected genotypes}
\usage{
CalcChi2(E, q, A.obs, ErrF)
}
\arguments{
\item{E}{presumed genotyping error rate}

\item{q}{allele frequency}

\item{A.obs}{array of dim 4x4x4 with counts of joined
offspring-parent-parent at the SNPs}

\item{ErrF}{ErrFlavour; function that takes the genotyping error rate
\code{Err} as input, and returns a 3x3 matrix of observed (columns)
conditional on actual (rows) genotypes, or choose from inbuilt ones as used
in sequoia 'version2.0', 'version1.3', or 'version1.1'. See
\code{\link{ErrToM}}.}
}
\value{
the chisquare value of the test
}
\description{
For one SNP and all offspring-parent-parent trios or single
  parent-offspring pairs, calculate the expected genotype frequencies given
  the allele frequency, genotyping error rate, and error flavour, and perform
  a chi-square test.
}
\examples{
\dontrun{
E.hat <- numeric(ncol(GenoM))  # based on trio where possible
for (l in 1:ncol(GenoM)) {
		E.hat[l] <- stats::optimise(CalcChi2, interval=c(0,1), q=AF[l],
		                     A.obs=OO.trio[l,,,], ErrF=ErrF)$minimum
} }
}
\seealso{
\code{\link{EstErr}, \link{SnpStats}}
}
\keyword{internal}
