% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.mhmm.R
\name{logLik.mhmm}
\alias{logLik.mhmm}
\title{Log-likelihood of the Mixture Hidden Markov Model}
\usage{
\method{logLik}{mhmm}(object, partials = FALSE, threads = 1, log_space = FALSE, ...)
}
\arguments{
\item{object}{A mixture hidden Markov model of class \code{mhmm}.}

\item{partials}{Return a vector containing the individual contributions of each sequence to the total log-likelihood. 
The default is \code{FALSE}, which returns the sum of all log-likelihood components.}

\item{threads}{Number of threads to use in parallel computing. The default is 1.}

\item{log_space}{Make computations using log-space instead of scaling for greater 
numerical stability at the cost of decreased computational performance. 
  The default is \code{TRUE}.}

\item{...}{Ignored.}
}
\value{
Log-likelihood of the mixture hidden Markov model. This is an object of class 
\code{logLik} with attributes \code{nobs} and \code{df} inherited from the model object.
}
\description{
Function \code{logLik.mhmm} computes the log-likelihood value of a mixture hidden Markov model.
}
\seealso{
\code{\link{build_mhmm}} and \code{\link{fit_model}} for building and 
  fitting mixture Hidden Markov models.
}
