% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol_convergence.R
\name{sobol_convergence}
\alias{sobol_convergence}
\title{Check convergence of Sobol' indices.}
\usage{
sobol_convergence(
  matrices,
  Y,
  N,
  sub.sample,
  params,
  first,
  total,
  order = order,
  seed = 666,
  plot.order,
  ...
)
}
\arguments{
\item{matrices}{Character vector with the required matrices. The default is \code{matrices = c("A", "B", "AB")}.
See \code{\link{sobol_matrices}}.}

\item{Y}{Numeric vector with the model output obtained from the matrix created with
\code{\link{sobol_matrices}}.}

\item{N}{Positive integer, the initial sample size of the base sample matrix created with \code{\link{sobol_matrices}}.}

\item{sub.sample}{Numeric vector with the sub-samples of the model output at which to check convergence.}

\item{params}{Character vector with the name of the model inputs.}

\item{first}{Estimator to compute first-order indices. Check options in \code{\link{sobol_indices}}.}

\item{total}{Estimator to compute total-order indices. Check options in \code{\link{sobol_indices}}.}

\item{order}{Whether to plot convergence for "second" or "third" order indices.}

\item{seed}{Whether to compute "first", "second", or "third" -order Sobol' indices. Default
is \code{order = "first"}.}

\item{plot.order}{Whether to plot convergence for "second" or "third"-order indices.}

\item{...}{Further arguments in \code{\link{sobol_indices}}.}
}
\value{
A list with the results and the plots
}
\description{
It checks the convergence of Sobol' indices on different sub-samples of the model output-.
}
\examples{
# Define settings
matrices <- c("A", "B", "AB")
params <- paste("X", 1:3, sep = "")
N <- 2^10
first <- "saltelli"
total <- "jansen"
order <- "second"

# Create sample matrix
mat <- sobol_matrices(N = N, params = params, order = order)

# Compute Ishigami function
Y <- ishigami_Fun(mat)

# Check convergence at specific sample sizes
sub.sample <- seq(100, N, 500) # Define sub-samples
sobol_convergence(matrices = matrices, Y = Y, N = N, sub.sample = sub.sample,
params = params, first = first, total = total, order = order, plot.order = order)
}
