% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projpar.R
\name{projpar}
\alias{projpar}
\alias{projname}
\title{Return a parameter used in a WKT projection}
\usage{
projpar(x, par, abort = FALSE)

projname(x, abort = FALSE)
}
\arguments{
\item{x}{The CRS to be named (any \link{st_crs2} input is accepted).}

\item{par}{Character corresponding to the parameter name
(it can be one among "name" and "unit" - case insensitive).}

\item{abort}{logical: if TRUE, the function aborts in case an invalid
CRS is passed; if FALSE (default), the function returns NA,
and a warning is shown.}
}
\value{
A character with the content of the parameter, and an
attribute \code{crs} with the input projection checked using
\code{\link[sf:st_crs]{sf::st_crs()}}.
}
\description{
Return the value of a parameter (the name or the unit)
present in the WKT of the given CRS.
}
\note{
The old function, which was searching for a generic parameter
parsing the WKT, was deprecated: now \code{\link[=projpar]{projpar()}} only accepts \code{par = "name"}
and \code{par = "unit"}, and \code{projname()} is an alias for \code{projpar(..., par = "name")}.

License: GPL 3.0
}
\examples{
\donttest{
projpar(4326, "name")
projpar(4326, "unit")
}
\donttest{
projname(4326)
}
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2020) \email{luigi@ranghetti.info}
}
