% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiles_intersects.R
\name{tiles_intersects}
\alias{tiles_intersects}
\title{Select the tiles intersecting the extent}
\usage{
tiles_intersects(extent, all = FALSE, out_format = "id", .s2tiles = NULL)
}
\arguments{
\item{extent}{\code{sf} object with the spatial extent.}

\item{all}{logical: if TRUE, all the tiles overlapping the extent are
provided;
if FALSE (default), unnecessary tiles are skipped.
Unnecessary tiles are tiles which overlaps the extent for an area already
covered by another tile.
In case the extent is all included in an overlapping area, only one of the
two candidate tiles is returned (the first in alphabetical order).}

\item{out_format}{character: if "sf", the spatial object of the overlapping tiles
is returned; if "id" (default), a character vector with the tile IDs.}

\item{.s2tiles}{output of \code{\link[=s2_tiles]{s2_tiles()}} function (it is possible to pass it
in order to speed up the execution;
otherwise leave to NULL and it will be generated within the function).}
}
\value{
the tiles intersecting the extent (see argument \code{out_format}).
}
\description{
Function which returns the tile IDs of the Sentinel-2 tiles
which overlap a provided extent.
}
\note{
License: GPL 3.0
}
\examples{
ex_extent <- sf::st_read(
  system.file("extdata/vector/scalve.kml", package = "sen2r"),
  quiet = TRUE
)
ex_extent <- ex_extent[1,]

# Tile ID of the required S2 tile
tiles_intersects(ex_extent)

# Tile ID of all the overlapping S2 tiles
tiles_intersects(ex_extent, all = TRUE)

# Spatial object with the required tile
sel_tiles <- tiles_intersects(ex_extent, out_format = "sf")
plot(sf::st_geometry(sel_tiles)); plot(sf::st_geometry(ex_extent), add=TRUE, col="yellow")

# Spatial object with the overlapping S2 tiles
sel_tiles <- tiles_intersects(ex_extent, all = TRUE, out_format = "sf")
plot(sf::st_geometry(sel_tiles)); plot(sf::st_geometry(ex_extent), add=TRUE, col="yellow")
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
