% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createRegSDCInput.R
\name{createRegSDCInput}
\alias{createRegSDCInput}
\title{Create input for RegSDC/other Tools}
\usage{
createRegSDCInput(x, chk = FALSE)
}
\arguments{
\item{x}{a \linkS4class{sdcProblem} object}

\item{chk}{a logical value deciding if computed linear relations should
be additionally checked for validity}
}
\value{
an \code{list} with the following elements:
\itemize{
\item \code{mat}: linear combinations depending on inner-cells of the given
problem instance.
\item \code{y}: a 1-column matrix containing the frequencies of inner cells
\item \code{z}: a 1-column matrix containing the frequencies of all cells
\item \code{z_supp}: a 1-column matrix containing the frequencies of all cells
but suppressed cells have a value of \code{NA}
\item \code{info}: a \code{data.frame} with the following columns:
\itemize{
\item \code{cell_id}: internal cell-id used in sdcTable
\item \code{is_innercell}: a binary indicator if the cell is an internal cell
(\code{TRUE}) or a (sub)total (\code{FALSE})
}
}
}
\description{
This function transforms a \linkS4class{sdcProblem} object into an object
that can be used as input for \link[RegSDC:SuppressDec]{RegSDC::SuppressDec} (among others).
}
\examples{
\dontrun{
utils::data("microdata1", package = "sdcTable")
head(microdata1)

# define the problem
dim_region <- hier_create(root = "total", nodes = sort(unique(microdata1$region)))
dim_gender <- hier_create(root = "total", nodes = sort(unique(microdata1$gender)))

prob <- makeProblem(
  data = microdata1,
  dimList = list(region = dim_region, gender = dim_gender),
  freqVarInd = NULL
)

# suppress some cells
prob <- primarySuppression(prob, type = "freq", maxN = 15)

# compute input for RegSDC-package
inp_regsdc <- createRegSDCInput(x = prob, chk = TRUE)

# estimate innner cells based on linear dependencies
res_regsdc <- RegSDC::SuppressDec(
  x = as.matrix(inp_regsdc$x),
  z = inp_regsdc$z_supp,
  y = inp_regsdc$y)[, 1]

# check if inner cells are all protected
df <- data.frame(
  freqs_orig = inp_regsdc$z[inp_regsdc$info$is_innercell == TRUE, ],
  freqs_supp = inp_regsdc$z_supp[inp_regsdc$info$is_innercell == TRUE, ],
  regsdc = res_regsdc
)

subset(df, df$regsdc == df$freqs_orig & is.na(freqs_supp))

}
}
\author{
Bernhard Meindl (bernhard.meindl@gmail.com)
}
