% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{Percent_Expressing}
\alias{Percent_Expressing}
\title{Calculate percent of expressing cells}
\usage{
Percent_Expressing(
  seurat_object,
  features,
  threshold = 0,
  group_by = NULL,
  split_by = NULL,
  entire_object = FALSE,
  layer = "data",
  assay = NULL
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{features}{Feature(s) to plot.}

\item{threshold}{Expression threshold to use for calculation of percent expressing (default is 0).}

\item{group_by}{Factor to group the cells by.}

\item{split_by}{Factor to split the groups by.}

\item{entire_object}{logical (default = FALSE).  Whether to calculate percent of expressing cells
across the entire object as opposed to by cluster or by \code{group_by} variable.}

\item{layer}{Which layer to pull expression data from?  Default is "data".}

\item{assay}{Assay to pull feature data from.  Default is active assay.}
}
\value{
A data.frame
}
\description{
Calculates the percent of cells that express a given set of features by various grouping factors
}
\examples{
\dontrun{
percent_stats <- Percent_Expressing(seurat_object = object, features = "Cx3cr1", threshold = 0)
}

}
\references{
Part of code is modified from Seurat package as used by \code{\link[Seurat]{DotPlot}}
to generate values to use for plotting.  Source code can be found here:
\url{https://github.com/satijalab/seurat/blob/4e868fcde49dc0a3df47f94f5fb54a421bfdf7bc/R/visualization.R#L3391} (License: GPL-3).
}
\concept{stats}
