% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emRHLP.R
\name{emRHLP}
\alias{emRHLP}
\title{emRHLP implements the EM algorithm to fit a RHLP model.}
\usage{
emRHLP(X, Y, K, p = 3, q = 1, variance_type = c("heteroskedastic",
  "homoskedastic"), n_tries = 1, max_iter = 1500, threshold = 1e-06,
  verbose = FALSE, verbose_IRLS = FALSE)
}
\arguments{
\item{X}{Numeric vector of length \emph{m} representing the covariates/inputs
\eqn{x_{1},\dots,x_{m}}.}

\item{Y}{Numeric vector of length \emph{m} representing the observed
response/output \eqn{y_{1},\dots,y_{m}}.}

\item{K}{The number of regimes (RHLP components).}

\item{p}{Optional. The order of the polynomial regression. By default, \code{p} is
set at 3.}

\item{q}{Optional. The dimension of the logistic regression. For the purpose
of segmentation, it must be set to 1 (which is the default value).}

\item{variance_type}{Optional character indicating if the model is
"homoskedastic" or "heteroskedastic". By default the model is
"heteroskedastic".}

\item{n_tries}{Optional. Number of runs of the EM algorithm. The solution
providing the highest log-likelihood will be returned.

If \code{n_tries} > 1, then for the first run, parameters are initialized by
uniformly segmenting the data into K segments, and for the next runs,
parameters are initialized by randomly segmenting the data into K
contiguous segments.}

\item{max_iter}{Optional. The maximum number of iterations for the EM
algorithm.}

\item{threshold}{Optional. A numeric value specifying the threshold for the
relative difference of log-likelihood between two steps of the EM as
stopping criteria.}

\item{verbose}{Optional. A logical value indicating whether or not values of
the log-likelihood should be printed during EM iterations.}

\item{verbose_IRLS}{Optional. A logical value indicating whether or not
values of the criterion optimized by IRLS should be printed at each step of
the EM algorithm.}
}
\value{
EM returns an object of class \link{ModelRHLP}.
}
\description{
emRHLP implements the maximum-likelihood parameter estimation of the RHLP
model by the Expectation-Maximization (EM) algorithm.
}
\details{
emRHLP function implements the EM algorithm for the RHLP model. This
function starts with an initialization of the parameters done by the method
\code{initParam} of the class \link{ParamRHLP}, then it alternates between
the E-Step (method of the class \link{StatRHLP}) and the M-Step
(method of the class \link{ParamRHLP}) until convergence (until the
relative variation of log-likelihood between two steps of the EM algorithm
is less than the \code{threshold} parameter).
}
\examples{
data(univtoydataset)

rhlp <- emRHLP(univtoydataset$x, univtoydataset$y, K = 3, p = 1, verbose = TRUE)

rhlp$summary()

rhlp$plot()
}
\seealso{
\link{ModelRHLP}, \link{ParamRHLP}, \link{StatRHLP}
}
