% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prodchisqpow.r
\name{prodchisqpow}
\alias{prodchisqpow}
\alias{dprodchisqpow}
\alias{pprodchisqpow}
\alias{qprodchisqpow}
\alias{rprodchisqpow}
\title{The product of (non-central) chi-squares raised to powers distribution.}
\usage{
dprodchisqpow(x, df, ncp=0, pow=1, log = FALSE, order.max=5)

pprodchisqpow(q, df, ncp=0, pow=1, lower.tail = TRUE, log.p = FALSE, order.max=5)

qprodchisqpow(p, df, ncp=0, pow=1, lower.tail = TRUE, log.p = FALSE, order.max=5)

rprodchisqpow(n, df, ncp=0, pow=1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{df}{the vector of degrees of freedom. 
This is recycled against the \code{ncp, pow}, but not against the \code{x,q,p,n}.}

\item{ncp}{the vector of non-centrality parameters. 
This is recycled against the \code{df, pow}, but not against the \code{x,q,p,n}.}

\item{pow}{the vector of the power parameters. 
This is recycled against the \code{df, ncp}, but not against the \code{x,q,p,n}.}

\item{log}{logical; if TRUE, densities \eqn{f} are given 
as \eqn{\mbox{log}(f)}{log(f)}.}

\item{order.max}{the order to use in the approximate density,
distribution, and quantile computations, via the Gram-Charlier,
Edeworth, or Cornish-Fisher expansion.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{log.p}{logical; if TRUE, probabilities p are given 
as \eqn{\mbox{log}(p)}{log(p)}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P[X \le x]}{P[X <= x]}, otherwise, \eqn{P[X > x]}{P[X > x]}.}
}
\value{
\code{dprodchisqpow} gives the density, \code{pprodchisqpow} gives the 
distribution function, \code{qprodchisqpow} gives the quantile function, 
and \code{rprodchisqpow} generates random deviates.

Invalid arguments will result in return value \code{NaN} with a warning.
}
\description{
Density, distribution function, quantile function and random
generation for the distribution of the product of non-central
chi-squares taken to powers.
}
\details{
Let \eqn{X_i \sim \chi^2\left(\delta_i, \nu_i\right)}{X_i ~ chi^2(delta_i, v_i)}
be independently distributed non-central chi-squares, where \eqn{\nu_i}{v_i}
are the degrees of freedom, and \eqn{\delta_i}{delta_i} are the
non-centrality parameters.  
Let \eqn{p_i} be given constants. Suppose
\deqn{Y = \prod_i X_i^{p_i}.}{Y = prod w_i (X_i)^(p_i).}
Then \eqn{Y}{Y} follows a product of chi-squares to power distribution.
}
\note{
The PDF, CDF, and quantile function are approximated, via
the Edgeworth or Cornish Fisher approximations, which may
not be terribly accurate in the tails of the distribution.
You are warned.

The distribution parameters are \emph{not} recycled
with respect to the \code{x, p, q} or \code{n} parameters,
for, respectively, the density, distribution, quantile
and generation functions. This is for simplicity of
implementation and performance. It is, however, in contrast
to the usual R idiom for dpqr functions.

The PDQ functions are computed by translation of the 
sum of log chi-squares distribution functions.
}
\examples{
df <- c(100,20,10)
ncp <- c(5,3,1)
pow <- c(1,0.5,1)
rvs <- rprodchisqpow(128, df, ncp, pow)
dvs <- dprodchisqpow(rvs, df, ncp, pow)
qvs <- pprodchisqpow(rvs, df, ncp, pow)
pvs <- qprodchisqpow(ppoints(length(rvs)), df, ncp, pow)
}
\references{
Pav, Steven. Moments of the log non-central chi-square distribution.
\url{http://arxiv.org/abs/1503.06266}
}
\seealso{
The sum of log of chi-squares distribution,
\code{\link{dsumlogchisq}},
\code{\link{psumlogchisq}},
\code{\link{qsumlogchisq}},
\code{\link{rsumlogchisq}},
The upsilon distribution, 
\code{\link{dupsilon}},
\code{\link{pupsilon}},
\code{\link{qupsilon}},
\code{\link{rupsilon}}.
The sum of chi-square powers distribution, 
\code{\link{dsumchisqpow}},
\code{\link{psumchisqpow}},
\code{\link{qsumchisqpow}},
\code{\link{rsumchisqpow}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{distribution}
