% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packs.R
\name{row-pack}
\alias{row-pack}
\title{Row rule pack}
\description{
Row rule pack is a \link[=rule-packs]{rule pack} which defines a set of rules for
rows as a whole, i.e. functions which convert rows of interest to logical
values. It should return a data frame with the following properties:
\itemize{
\item Number of rows equals to \strong{number of checked rows}.
\item Column names should be treated as \strong{rule names}.
\item Values indicate whether the \strong{row as a whole} follows the rule.
}
}
\details{
This format is inspired by \code{dplyr}'s \link[dplyr:transmute]{transmute()}.

The most common way to define row pack is by creating a \link[magrittr:pipe]{functional sequence} containing \code{transmute(...)}.
}
\section{Note about rearranging rows}{

\strong{Note} that during exposure packs are applied to \link[keyholder:keys-set]{keyed object} with \link[keyholder:keyholder-id]{id key}. So they
can rearrange rows as long as it is done with \link[keyholder:keyholder-supported-funs]{functions supported by keyholder}. Rows will be tracked and
recognized as in the original data frame of interest.
}

\examples{
some_row_mean_rules <- . \%>\% dplyr::slice(1:3) \%>\%
  dplyr::mutate(row_mean = rowMeans(.)) \%>\%
  dplyr::transmute(
    row_mean_low = row_mean > 10,
    row_mean_up = row_mean < 20
  )
all_row_sum_rules <- . \%>\% dplyr::mutate(row_sum = rowSums(.)) \%>\%
  dplyr::transmute(row_sum_low = row_sum > 30)

row_packs(
  some_row_mean_rules,
  all_row_sum_rules
)

}
\seealso{
\link[=data-pack]{Data pack}, \link[=group-pack]{group pack}, \link[=column-pack]{column pack}, \link[=cell-pack]{cell pack}.
}
