% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_responses.R
\name{generate_item_responses_sml}
\alias{generate_item_responses_sml}
\title{Internals: simulating responding to item in a 'simultaneous' way}
\usage{
generate_item_responses_sml(theta, scoringMatrix, slopes, intercepts)
}
\arguments{
\item{theta}{matrix of latent traits' values}

\item{scoringMatrix}{matrix describing scoring patterns on each latent trait}

\item{slopes}{vector of slope parameters of each trait}

\item{intercepts}{intercept parameters}
}
\value{
vector of responses on item
}
\description{
Function generates responses 'simultaneously` with a whole
scoring matrix used at once. Only (G)PCM approach is suitable in such a case,
because with complicated scoring matrices there is no guarantee that
probabilities of responses are increasing along with order of responses
(rows) in a scoring matrix. Consequently, no normal ogive models can be used.
}
\seealso{
\code{link{generate_test_responses}},
\code{\link{generate_item_responses_sqn}},
\code{\link{generate_item_responeses_gpcm}}
}
