% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_responses.R
\name{expand_responses}
\alias{expand_responses}
\title{Helper functions for manipulating generated responses}
\usage{
expand_responses(responses, scoringMatrix)
}
\arguments{
\item{responses}{matrix of responses with items in columns and observations
in rows}

\item{scoringMatrix}{matrix describing scoring patterns on each latent trait}
}
\value{
matrix (of integers)
}
\description{
Using scoring matrix provided as its second argument function
\emph{expands} (recodes) responses to each item (column) in a provided matrix
of responses into a set of variables that may be put into model estimation.
}
\examples{
sM <- make_scoring_matrix_aem(5, "mae")
responses <- matrix(sample(1L:5L, 20, replace = TRUE), ncol = 4,
                    dimnames = list(NULL, paste0("item", 1:4)))
responses
sM
expand_responses(responses, sM)
}
