% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-aao.R
\name{download_aao}
\alias{download_aao}
\title{Download Arctic Oscillation data}
\usage{
download_aao(use_cache = FALSE, file = NULL)
}
\arguments{
\item{use_cache}{logical option to save and load from cache. If `TRUE`, results will be cached in memory
if `file` is `NULL` or on disk if `file` is not `NULL`.}

\item{file}{optional character with the full path of a file to save the data. If `cache` is `FALSE` but
`file` is not `NULL`, the results will be downloaded from the internet and saved on disk.}
}
\value{
\itemize{
\item Month: Month of record
\item Year: Year of record
\item aao: Antarctic Oscillation
}
}
\description{
Projection of the daily 1000 hPa anomaly height field north of 20°N on the first EOF obtained
from the monthly 1000 hPa height anomaly.
}
\examples{
\dontrun{
aao <- download_aao()
}

}
\references{
\url{https://www.cpc.ncep.noaa.gov/products/precip/CWlink/daily_ao_index/aao/aao_index.html}
}
