% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splineDensity.smoothingSplinesValidation.R
\name{smoothSplinesVal}
\alias{smoothSplinesVal}
\title{Estimate density from histogram - for different \code{alpha}}
\usage{
smoothSplinesVal(
  k,
  l,
  alpha,
  data,
  xcp,
  knots,
  weights = matrix(1, dim(data)[1], dim(data)[2]),
  prior = "default",
  cores = 1
)
}
\arguments{
\item{k}{smoothing splines degree}

\item{l}{order of derivative in the penalization term}

\item{alpha}{vector of weights for penalization}

\item{data}{an object of class "matrix" containing data to be smoothed, row by row}

\item{xcp}{vector of control points}

\item{knots}{either vector of knots for the splines or a integer for the number of equispaced knots}

\item{weights}{matrix of weights. If not gives, all data points will be weighted the same.}

\item{prior}{prior used for zero-replacements. This must be one of "perks", "jeffreys", "bayes_laplace", "sq" or "default"}

\item{cores}{number of cores for parallel execution}
}
\value{
A list of three objects:
\item{\code{alpha}}{the values of \code{alpha}}
\item{\code{J}}{the values of the functional evaluated in the minimizing}
\item{\code{CV-error}}{the values of the leave-one-out CV-error}
}
\description{
As \code{\link{smoothSplines}}, \code{smoothSplinesVal} computes the density function that 'best' fits
discretized distributional data, using B-spline basis functions, for different \code{alpha}. \cr
Comparing and choosing an appropriate \code{alpha} is the ultimate goal.
}
\details{
See \code{\link{smoothSplines}} for the description of the algorithm.
}
\examples{
SepalLengthCm <- iris$Sepal.Length
Species <- iris$Species

iris1 <- SepalLengthCm[iris$Species==levels(iris$Species)[1]]
h1 <- hist(iris1, nclass = 12, plot = FALSE)

\dontrun{
midx1 <- h1$mids
midy1 <- matrix(h1$density, nrow=1, ncol = length(h1$density), byrow=TRUE)
knots <- 7
sol1 <- smoothSplinesVal(k=3,l=2,alpha=10^seq(-4,4,by=1),midy1,midx1,knots,cores=1)
}
}
\references{
J. Machalova, K. Hron & G.S. Monti (2016):
Preprocessing of centred logratio transformed density functions
using smoothing splines. Journal of Applied Statistics, 43:8, 1419-1435.
}
\author{
Alessia Di Blasi, Federico Pavone, Gianluca Zeni, Matthias Templ
}
