% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustCoDa.R
\name{clustCoDa}
\alias{clustCoDa}
\alias{plot.clustCoDa}
\title{Cluster analysis for compositional data}
\usage{
clustCoDa(x, k = NULL, method = "Mclust", scale = "robust",
  transformation = "pivotCoord", distMethod = NULL, iter.max = 100,
  vals = TRUE, alt = NULL, bic = NULL, verbose = TRUE)

\method{plot}{clustCoDa}(x, y, ..., normalized = FALSE,
  which.plot = "clusterMeans", measure = "silwidths")
}
\arguments{
\item{x}{compositional data represented as a data.frame}

\item{k}{number of clusters}

\item{method}{clustering method. One of Mclust, cmeans, kmeansHartigan,
cmeansUfcl, pam, clara, fanny, ward.D2, single, hclustComplete, 
average, mcquitty, median, centroid}

\item{scale}{If orthonormal coordinates should be normalized.}

\item{transformation}{default is the isometric log-ratio transformation. Can only used when distMethod 
is not Aitchison.}

\item{distMethod}{Distance measure to be used. If \dQuote{Aitchison}, then transformation should be \dQuote{identity}.}

\item{iter.max}{parameter if kmeans is chosen. The maximum number of iterations allowed}

\item{vals}{if cluster validity measures should be calculated}

\item{alt}{a known partitioning can be provided (for special cluster validity measures)}

\item{bic}{if TRUE then the BIC criteria is evaluated for each single cluster as validity measure}

\item{verbose}{if TRUE additional print output is provided}

\item{y}{the y coordinates of points in the plot, optional if x is an appropriate structure.}

\item{...}{additional parameters for print method passed through}

\item{normalized}{results gets normalized before plotting. Normalization is done by z-transformation 
applied on each variable.}

\item{which.plot}{currently the only plot. Plot of cluster centers.}

\item{measure}{cluster validity measure to be considered for which.plot equals \dQuote{partMeans}}
}
\value{
all relevant information such as cluster centers, cluster memberships, and
cluster statistics.
}
\description{
Clustering in orthonormal coordinates or by using the Aitchison distance
}
\details{
The compositional data set is either internally represented by orthonormal coordiantes
before a cluster algorithm is applied, or - depending on the 
choice of parameters -  the Aitchison distance is used.
}
\examples{
data(expenditures)
x <- expenditures
rr <- clustCoDa(x, k=6, scale = "robust", transformation = "pivotCoord")
rr2 <- clustCoDa(x, k=6, distMethod = "Aitchison", scale = "none", 
                 transformation = "identity")
rr3 <- clustCoDa(x, k=6, distMethod = "Aitchison", method = "single",
                 transformation = "identity", scale = "none")
plot(rr)
plot(rr, normalized = TRUE)
plot(rr, normalized = TRUE, which.plot = "partMeans")
}
\references{
M. Templ, P. Filzmoser, C. Reimann.
Cluster analysis applied to regional geochemical data: Problems and possibilities. 
\emph{Applied Geochemistry}, \strong{23} (8), 2198--2213, 2008

Templ, Filzmoser, Reimann (2008) 
\emph{Cluster analysis applied to regional geochemical data: Problems and possibilities"}, 
Applied Geochemistry, 23 (2008), pages 2198 - 2213.
}
\author{
Matthias Templ (accessing the basic features of hclust, Mclust, kmeans, etc. that 
are all written by others)
}
\keyword{multivariate}
