% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_geoserver.R
\name{npn_download_geospatial}
\alias{npn_download_geospatial}
\title{Download Geospatial Data}
\usage{
npn_download_geospatial(
  coverage_id,
  date,
  format = "geotiff",
  output_path = NULL
)
}
\arguments{
\item{coverage_id}{The coverage id (machine name) of the layer for which to retrieve.
Applicable values can be found via the npn_get_layer_details() function under the 'name' column.}

\item{date}{Specify the date param for the layer retrieved. This can be a calendar
date formatted YYYY-mm-dd or it could be a string integer representing day of year.
It can also be NULL in some cases. Which to use depends entirely on the layer being
requested. More information available from the npn_get_layer_details() function.}

\item{format}{The output format of the raster layer retrieved. Defaults to GeoTIFF.}

\item{output_path}{Optional value. When set, the raster will be piped to the file
path specified. When left unset, this function will return a raster object.}
}
\value{
Raster object meeting the coverage_id, date and format parameters specified.
}
\description{
Function for directly downloading any arbitrary Geospatial layer data from the NPN Geospatial web services.
}
\details{
Information about the layers can also be viewed at the getCapbilities page directly:
 https://geoserver.usanpn.org/geoserver/wms?request=GetCapabilities
}
\examples{
\dontrun{
ras<-npn_download_geospatial("si-x:30yr_avg_six_bloom","255")
}
}
