% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RiverDirection.R
\name{RiverDirection}
\alias{RiverDirection}
\title{River Direction Arrow}
\usage{
RiverDirection(riverlayout, loc = NA, arw.length = 0.05, arw.lty = 1,
  arw.lwd = 1, arw.angle = 30, arw.col = "black",
  label = "Flow direction", lbl.cex = 0.5, lbl.pos = 4, lbl.ofs = 0.5)
}
\arguments{
\item{riverlayout}{the output list of \code{RiverLayout} or \code{RiverMap}.}

\item{loc}{location of arrow. One or two values in the range [0, 1] for left
and bottom margin sizes. If \code{loc = NA}, use mouse to locate the arrow.
ESC to confirm.}

\item{arw.length}{arrow length.}

\item{arw.lty}{arrow line style.}

\item{arw.lwd}{arrow line width.}

\item{arw.angle}{arrow head angle.}

\item{arw.col}{arrow colour.}

\item{label}{label of the arrow.}

\item{lbl.cex}{label size.}

\item{lbl.pos}{label position.}

\item{lbl.ofs}{label position offset.}
}
\description{
This plots river flow direction arrow on river charts.
}
\examples{
data(Ballinderry)

riverlayout <- RiverLayout(B.river$River,B.river$Length,
                           B.river$Parent,B.river$Position,
                           B.river$Distance, direction = -1)
RiverDraw(riverlayout)

RiverDirection(riverlayout, arw.length = 0.03,
               loc = c(0.8, 0.05), lbl.cex = 0.8)

# Use mouse to allocate the flow direction sign
## RiverDirection(riverlayout, arw.length = 0.03, lbl.cex = 0.8)
}
\author{
Feng Mao
}
\seealso{
\code{\link{RiverLayout}}, \code{\link{RiverDraw}},
\code{\link{RiverMap}}, \code{\link{par}}, \code{\link{locator}},
\code{\link{arrows}}.
}
\keyword{hplot}

