% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_session_dependencies.R
\name{get_session_dependencies}
\alias{get_session_dependencies}
\title{Get Dependencies}
\usage{
get_session_dependencies(deps_list)
}
\arguments{
\item{deps_list}{A data frame containing the dependency information of the package (provided by calc_dependencies function)}
}
\value{
A list with two elements:
\item{imports}{A named list of packages in the "Imports" section along with their corresponding versions }
\item{suggests}{A named list of packages in the "Suggests" section along with their corresponding versions }
}
\description{
This function extracts the version information of imported and suggested packages for a given package from the current R session.
}
\examples{
\donttest{
deps_list <- data.frame(
  package = c("dplyr", "ggplot2", "testthat", "knitr"),
  type = c("Imports", "Imports", "Suggests", "Suggests")
)
get_session_dependencies(deps_list)
}

}
