% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud.R
\name{cloudDownload}
\alias{cloudDownload}
\title{Download from cloud, if necessary}
\usage{
cloudDownload(
  outputHash,
  newFileName,
  gdriveLs,
  cachePath,
  cloudFolderID,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose")
)
}
\arguments{
\item{outputHash}{The \code{cacheId} of the object to upload}

\item{newFileName}{The character string of the local filename that the downloaded object will have}

\item{gdriveLs}{The result of \code{googledrive::drive_ls(googledrive::as_id(cloudFolderID), pattern = "outputHash")}}

\item{cachePath}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{cloudFolderID}{A googledrive dribble of a folder, e.g., using \code{drive_mkdir()}.
If left as \code{NULL}, the function will create a cloud folder with name from last
two folder levels of the \code{cachePath} path, :
\code{paste0(basename(dirname(cachePath)), "_", basename(cachePath))}.
This \code{cloudFolderID} will be added to \code{options("reproducible.cloudFolderID")},
but this will not persist across sessions. If this is a character string, it will
treat this as a folder name to create or use on GoogleDrive.}

\item{drv}{if using a database backend, drv must be an object that
inherits from DBIDriver e.g., from package RSQLite, e.g., SQLite}

\item{conn}{an optional DBIConnection object, as returned by dbConnect().}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}
}
\description{
Meant for internal use, as there are internal objects as arguments.
}
