% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.requireNamespace}
\alias{.requireNamespace}
\title{Provide standard messaging for missing package dependencies}
\usage{
.requireNamespace(
  pkg = "methods",
  minVersion = NULL,
  stopOnFALSE = FALSE,
  messageStart = paste0(pkg, if (!is.null(minVersion)) paste0("(>=", minVersion, ")"),
    " is required. Try: ")
)
}
\arguments{
\item{pkg}{Character string indicating name of package required}

\item{minVersion}{Character string indicating minimum version of package
that is needed}

\item{stopOnFALSE}{Logical. If \code{TRUE}, this function will create an
error (i.e., \code{stop}) if the function returns \code{FALSE}; otherwise
it simply returns \code{FALSE}}

\item{messageStart}{A character string with a prefix of message to provide}
}
\value{
A logical or stop if the namespace is not available to be loaded.
}
\description{
This provides a standard message format for missing packages, e.g.,
detected via \code{requireNamespace}.
}
