% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preProcess.R
\name{.purge}
\alias{.purge}
\title{Purge individual line items from checksums file}
\usage{
.purge(checkSums, purge, targetFile, archive, alsoExtract, url)
}
\arguments{
\item{checkSums}{A checksums file, e.g., created by Checksums(..., write = TRUE)}

\item{purge}{Logical or Integer. \code{0/FALSE} (default) keeps existing
\code{CHECKSUMS.txt} file and
\code{prepInputs} will write or append to it. \code{1/TRUE} will deleted the entire
\code{CHECKSUMS.txt} file. Other options, see details.}

\item{targetFile}{Character string giving the path to the eventual file
(raster, shapefile, csv, etc.) after downloading and extracting from a zip
or tar archive. This is the file \emph{before} it is passed to
\code{postProcess}. Currently, the internal checksumming does not checksum
the file after it is \code{postProcess}ed (e.g., cropped/reprojected/masked).
Using \code{Cache} around \code{prepInputs} will do a sufficient job in these cases.
See table in \code{\link{preProcess}}.}

\item{archive}{Optional character string giving the path of an archive
containing \code{targetFile}, or a vector giving a set of nested archives
(e.g., \code{c("xxx.tar", "inner.zip", "inner.rar")}). If there is/are (an) inner
archive(s), but they are unknown, the function will try all until it finds
the \code{targetFile}. See table in \code{\link{preProcess}}.}

\item{url}{Optional character string indicating the URL to download from.
If not specified, then no download will be attempted. If not entry
exists in the \code{CHECKSUMS.txt} (in \code{destinationPath}), an entry
will be created or appended to. This \code{CHECKSUMS.txt} entry will be used
in subsequent calls to
\code{prepInputs} or \code{preProcess}, comparing the file on hand with the ad hoc
\code{CHECKSUMS.txt}. See table in \code{\link{preProcess}}.}
}
\description{
Purge individual line items from checksums file
}
\keyword{internal}
