% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R, R/cache-tools.R
\name{getFunctionName}
\alias{getFunctionName}
\alias{.digestRasterLayer}
\alias{getUserTags}
\alias{getCacheId}
\alias{getArtifact}
\title{A set of helpers for Cache}
\usage{
getFunctionName(FUN, originalDots, ..., overrideCall, isPipe)

.digestRasterLayer(object, length, algo, quick)

getUserTags(cacheRepo, shownCache, cacheId, concatenated = TRUE)

getCacheId(cacheRepo, shownCache, artifact)

getArtifact(cacheRepo, shownCache, cacheId)
}
\arguments{
\item{FUN}{A function}

\item{...}{passing the \code{...} from outer function, which will include potential
arguments to the \code{FUN}}

\item{overrideCall}{A character string indicating a different (not "Cache") function
name to search for. Mostly so that this works with deprecated "cache".}

\item{isPipe}{Logical. If the call to \code{getFunctionName} is coming from a pipe, there is more
information available. Specifically, \code{._lhs} which is already a call.}

\item{length}{Numeric. If the element passed to Cache is a \code{Path} class
object (from e.g., \code{asPath(filename)}) or it is a \code{Raster} with
file-backing, then this will be
passed to \code{digest::digest}, essentially limiting the number of bytes
to digest (for speed). This will only be used if \code{quick = FALSE}.
Default is \code{getOption("reproducible.length")}, which is set to \code{Inf}.}

\item{algo}{The algorithms to be used; currently available choices are
    \code{md5}, which is also the default, \code{sha1}, \code{crc32},
    \code{sha256}, \code{sha512}, \code{xxhash32}, \code{xxhash64},
    \code{murmur32} and \code{spookyhash}.}

\item{quick}{Logical. If \code{TRUE},
little or no disk-based information will be assessed, i.e., mostly its
memory content. This is relevant for objects of class \code{character},
\code{Path} and \code{Raster} currently. For class \code{character}, it is ambiguous
whether this represents a character string or a vector of file paths. The function
will assess if it is a path to a file or directory first. If not, it will treat
the object as a character string. If it is known that character strings should
not be treated as paths, then \code{quick = TRUE} will be much faster, with no loss
of information. If it is file or directory, then it will digest the file content,
or \code{basename(object)}. For class \code{Path} objects, the file's metadata
(i.e., filename and file size) will be hashed instead of the file contents if
\code{quick = TRUE}.
If set to \code{FALSE} (default), the contents of the file(s) are hashed.
If \code{quick = TRUE}, \code{length} is ignored. \code{Raster} objects are treated
as paths, if they are file-backed.}

\item{cacheRepo}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{shownCache}{Primary way of supplying \code{cacheRepo}; the data.table obj
resulting from \code{showCache}, i.e., it will override \code{cacheRepo}.
If this and \code{cacheRepo} are missing, then it will default to
\code{getOption('reproducible.cachePath')}}

\item{cacheId}{A character vector of cacheId values to use in the cache}

\item{concatenated}{Logical. If \code{TRUE}, the returned \code{userTags} will
be concatenated \code{tagKey:tagValue}.}

\item{artifact}{Character vector of artifact values in the
\code{artifact} column of \code{showCache}}
}
\value{
\code{getCacheId} returns the \code{cacheId} values for 1 or more artifacts in the cache.

\code{getArtifact} returns the \code{artifact} value for 1 or more
entries in the cache, by \code{cacheId}.
}
\description{
These are internal only.

A few helpers to get specific things from the cache repository
}
\note{
If the function cannot figure out a clean function name, it returns "internal"
}
\author{
Eliot McIntire
}
\keyword{internal}
