% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcess.R
\name{determineFilename}
\alias{determineFilename}
\title{Determine filename, either automatically or manually}
\usage{
determineFilename(filename2 = TRUE, filename1 = NULL,
  destinationPath = NULL, prefix = "Small", ...)
}
\arguments{
\item{filename2}{\code{filename2} is optional, and is either
NULL (no writing of outputs to disk), or several options
for writing the object to disk. If
\code{TRUE} (the default), it will give it a file name determined by
\code{.prefix(basename(filename1), prefix)}. If
a character string, it will use this as its file name. See
\code{\link{determineFilename}}.}

\item{filename1}{Character strings giving the file paths of
the \emph{input} object (\code{filename1}) \code{filename1}
is only used for messaging (i.e., the object itself is passed
in as \code{x}) and possibly naming of output (see details
and \code{filename2}).}

\item{destinationPath}{Optional. If \code{filename2} is a relative file path, then this
will be the directory of the resulting absolute file path.}

\item{prefix}{The character string to prepend to \code{filename1}, if \code{filename2}
not provided.}

\item{...}{Additional arguments passed to methods. For \code{spatialObjects},
           these are: \code{\link{cropInputs}},
           \code{\link{fixErrors}},
           \code{\link{projectInputs}}, \code{\link{maskInputs}},
           \code{\link{determineFilename}}, and \code{\link{writeOutputs}}.
           Each of these may also pass \code{...} into other functions, like
           \code{\link[raster]{writeRaster}}, or \code{sf::st_write}.
           This might include potentially important arguments like \code{datatype},
           \code{format}. Also passed to \code{projectRaster},
           with likely important arguments such as \code{method = "bilinear"}.
           See details.

\subsection{... passed to:}{
  \tabular{lccc}{
     Function                \tab Arguments \cr
    \code{cropInputs}        \tab \code{\link[raster]{crop}} \cr
    \code{projectInputs}     \tab \code{\link[raster]{projectRaster}}\cr
    \code{maskInputs}        \tab \code{\link{fastMask}} or \code{\link[raster]{intersect}}\cr
    \code{fixErrors}         \tab \code{\link[raster]{buffer}}\cr
    \code{writeOutputs}      \tab \code{\link[raster]{writeRaster}} or \code{\link[raster]{shapefile}}\cr
    \code{determineFilename} \tab \cr
  }
  * Can be overridden with \code{useSAcrs}
  ** Will mask with \code{NA}s from \code{rasterToMatch} if \code{maskWithRTM}
}}
}
\description{
Determine the filename, given various combinations of inputs.
}
\details{
The post processing workflow, which includes this function,
addresses several scenarios, and depending on which scenario, there are
several file names at play. For example, \code{Raster} objects may have
  file-backed data, and so \emph{possess a file name}, whereas \code{Spatial}
  objects do not. Also, if post processing is part of a \code{\link{prepInputs}}
  workflow, there will always be a file downloaded. From the perspective of
  \code{postProcess}, these are the "inputs" or \code{filename1}.
  Similarly, there may or may not be a desire to write an
  object to disk after all post processing, \code{filename2}.

  This subtlety means that there are two file names that may be at play:
  the "input" file name (\code{filename1}), and the "output" filename (\code{filename2}).
  When this is used within \code{postProcess}, it is straight forward.


  However, when \code{postProcess} is used within a \code{prepInputs} call,
  the \code{filename1} file is the file name of the downloaded file (usually
  automatically known following the downloading, and refered to as \code{targetFile})
  and the \code{filename2} is the file name of the of post-processed file.

  If \code{filename2} is \code{TRUE}, i.e., not an actual file name, then the cropped/masked
  raster will be written to disk with the original \code{filenam1/targetFile}
  name, with \code{prefix} prefixed to the basename(\code{targetFile}).

  If \code{filename2} is a character string, it will be the path of the saved/written
  object e.g., passed to \code{writeOutput}. It will be tested whether it is an
  absolute or relative path and used as is if absolute or
  prepended with \code{destinationPath} if relative.

If \code{filename2} is \code{logical}, then the output
 filename will be \code{prefix} prefixed to the basename(\code{filename1}).
 If a character string, it
 will be the path returned. It will be tested whether it is an
 absolute or relative path and used as is if absolute or prepended with
 \code{destinationPath} if provided, and if \code{filename2} is relative.
}
\examples{
# Add a study area to Crop and Mask to
# Create a "study area"
library(sp)
library(raster)
ow <- setwd(tempdir())

# make a SpatialPolygon
coords1 <- structure(c(-123.98, -117.1, -80.2, -100, -123.98, 60.9, 67.73, 65.58, 51.79, 60.9),
                    .Dim = c(5L, 2L))
Sr1 <- Polygon(coords1)
Srs1 <- Polygons(list(Sr1), "s1")
shpEcozone <- SpatialPolygons(list(Srs1), 1L)
crs(shpEcozone) <- "+init=epsg:4326 +proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"

# make a "study area" that is subset of larger dataset
coords <- structure(c(-118.98, -116.1, -99.2, -106, -118.98, 59.9, 65.73, 63.58, 54.79, 59.9),
                    .Dim = c(5L, 2L))
Sr1 <- Polygon(coords)
Srs1 <- Polygons(list(Sr1), "s1")
StudyArea <- SpatialPolygons(list(Srs1), 1L)
crs(StudyArea) <- "+init=epsg:4326 +proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"
#'
#'
##########
shpEcozonePostProcessed <- postProcess(shpEcozone, studyArea = StudyArea)
#'
# Try manually, individual pieces
shpEcozoneReprojected <- projectInputs(shpEcozone, StudyArea)
shpEcozoneCropped <- cropInputs(shpEcozone, StudyArea)
shpEcozoneClean <- fixErrors(shpEcozone)
shpEcozoneMasked <- maskInputs(shpEcozone, StudyArea)

setwd(ow)
}
