% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R
\name{copyFile}
\alias{copyFile}
\title{Copy a file using \code{Robocopy} on Windows and \code{rsync} on Linux/macOS}
\usage{
copyFile(from = NULL, to = NULL, useRobocopy = TRUE, overwrite = TRUE,
  delDestination = FALSE, create = TRUE, silent = FALSE)
}
\arguments{
\item{from}{The source file.}

\item{to}{The new file.}

\item{useRobocopy}{For Windows, this will use a system call to \code{Robocopy}
which appears to be much faster than the internal \code{file.copy} function.
Uses \code{/MIR} flag. Default \code{TRUE}.}

\item{overwrite}{Passed to \code{file.copy}}

\item{delDestination}{Logical, whether the destination should have any files deleted,
if they don't exist in the source. This is \code{/purge}.}

\item{create}{Passed to \code{checkLazyDir}.}

\item{silent}{Should a progress be printed.}
}
\description{
This will copy an individual file faster using \code{Robocopy} on Windows,
and using \code{rsync} on macOS and Linux.
}
\examples{
tmpDirFrom <- file.path(tempdir(), "example_fileCopy_from")
tmpDirTo <- file.path(tempdir(), "example_fileCopy_to")
tmpFile <- tempfile("file", tmpDirFrom, ".csv")
dir.create(tmpDirFrom)
f1 <- normalizePath(tmpFile, mustWork = FALSE)
f2 <- normalizePath(file.path(tmpDirTo, basename(tmpFile)), mustWork = FALSE)

write.csv(data.frame(a = 1:10, b = runif(10), c = letters[1:10]), f1)
copyFile(f1, f2)
file.exists(f2) ## TRUE
identical(read.csv(f1), read.csv(f2)) ## TRUE

unlink(tmpDirFrom, recursive = TRUE)
unlink(tmpDirTo, recursive = TRUE)

}
\author{
Eliot McIntire and Alex Chubaty
}
