% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load}
\alias{load}
\title{Load a Project}
\usage{
load(project = getwd(), quiet = FALSE)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{quiet}{Boolean; be quiet during load?}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Load a project.
}
\details{
Normally, this is done automatically on session startup by the infrastructure
generated by \code{\link[=activate]{activate()}} -- users should not need to call this function
directly.
}
\examples{
\dontrun{

# load a project -- note that this is normally done automatically
# when the R session is started in an renv project after calling
# renv::activate()
renv::load()

}
}
