% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_duplicate.R
\name{best_duplicate}
\alias{best_duplicate}
\title{Choose the best duplicate}
\usage{
best_duplicate(data, id)
}
\arguments{
\item{data}{The data frame.}

\item{id}{The ID variable for which to check for duplicates.}
}
\value{
A dataframe, containing only the "best" duplicates.
}
\description{
Chooses the best duplicate, based on the
duplicate with the smallest number of missing values. In case of
ties, it picks the first duplicate, as it is the one most likely
to be valid and authentic, given practice effects.
}
\details{
For the \emph{easystats} equivalent, see:
\code{\link[datawizard:data_duplicated]{datawizard::data_duplicated()}}.
}
\examples{
df1 <- data.frame(
   id = c(1, 2, 3, 1, 3),
   item1 = c(NA, 1, 1, 2, 3),
   item2 = c(NA, 1, 1, 2, 3),
   item3 = c(NA, 1, 1, 2, 3)
)

best_duplicate(df1, id = "id")

}
\keyword{duplicates}
