% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_lm_contrasts.R
\name{nice_lm_contrasts}
\alias{nice_lm_contrasts}
\title{Easy planned contrasts using lm models}
\usage{
nice_lm_contrasts(
  model,
  group,
  data,
  effect.type = "cohens.d",
  bootstraps = 2000,
  ...
)
}
\arguments{
\item{model}{The model to be formatted.}

\item{group}{The group for the comparison.}

\item{data}{The data frame.}

\item{effect.type}{What effect size type to use. One of "cohens.d" (default),
"akp.robust.d", "unstandardized", "hedges.g", "cohens.d.sigma", or "r".}

\item{bootstraps}{The number of bootstraps to use for the confidence interval}

\item{...}{Arguments passed to \link[bootES:bootES]{bootES::bootES}.}
}
\value{
A dataframe, with the selected dependent variable(s), comparisons of
interest, degrees of freedom, t-values, p-values, Cohen's d, and the
lower and upper 95\% confidence intervals of the
effect size (i.e., dR).
}
\description{
Easily compute planned contrast analyses (pairwise
comparisons similar to t-tests but more powerful when more than
2 groups), and format in publication-ready format. Supports only
three groups for the moment. In this particular case, the
confidence intervals are bootstraped on chosen effect size
(default to Cohen's d).
}
\details{
Statistical power is lower with the standard \emph{t} test
compared than it is with the planned contrast version for two
reasons: a) the sample size is smaller with the \emph{t} test,
because only the cases in the two groups are selected; and b)
in the planned contrast the error term is smaller than it is
with the standard \emph{t} test because it is based on all the cases
(\href{https://web.pdx.edu/~newsomj/uvclass/ho_planned\%20contrasts.pdf}{source}).

The effect size and confidence interval are calculated via
\link[bootES:bootES]{bootES::bootES}.
}
\examples{
# Make and format model (group need to be a factor)
model <- lm(mpg ~ as.factor(cyl) + wt * hp, mtcars)
nice_lm_contrasts(model, group = "cyl", data = mtcars, bootstraps = 500)

model2 <- lm(qsec ~ as.factor(cyl), data = mtcars)
my.models <- list(model, model2)

nice_lm_contrasts(my.models, group = "cyl", data = mtcars, bootstraps = 500)

}
\seealso{
\code{\link{nice_contrasts}},
Tutorial: \url{https://rempsyc.remi-theriault.com/articles/contrasts}
}
\keyword{comparisons}
\keyword{contrasts}
\keyword{differences}
\keyword{group}
\keyword{pairwise}
\keyword{planned}
