% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discTL.R
\name{discTL}
\alias{discTL}
\alias{discTL.default}
\alias{discTL.formula}
\title{Tomek Links for Regression by Discretization}
\usage{
\method{discTL}{default}(x, y, ...)

\method{discTL}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a double vector with the output regressand of each sample.}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output regressand and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
The result of applying the regression filter is a reduced dataset containing the clean samples (without errors or noise), since it removes noisy samples (those with errors).
This function returns an object of class \code{rfdata}, which contains information related to the noise filtering process in the form of a list with the following elements:
\item{xclean}{a data frame with the input attributes of clean samples (without errors).}
\item{yclean}{a double vector with the output regressand of clean samples (without errors).}
\item{numclean}{an integer with the amount of clean samples.}
\item{idclean}{an integer vector with the indices of clean samples.}
\item{xnoise}{a data frame with the input attributes of noisy samples (with errors).}
\item{ynoise}{a double vector with the output regressand of noisy samples (with errors).}
\item{numnoise}{an integer with the amount of noisy samples.}
\item{idnoise}{an integer vector with the indices of noisy samples.}
\item{filter}{the full name of the noise filter used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}

Note that objects of the class \code{rfdata} support \link{print.rfdata}, \link{summary.rfdata} and \link{plot.rfdata} methods.
}
\description{
Application of the discTL noise filtering method in a regression dataset.
}
\details{
\code{discTL} discretizes the numerical output variable to make it compatible with \emph{Tomek Links} (TL), typically used in classification tasks. 
TL identifies pairs of instances that are close neighbors but belong to different classes. 
If an instance in such a pair is predominantly surrounded by instances from a different class, it may be flagged as noisy.
}
\examples{
# load the dataset
data(rock)

# usage of the default method
set.seed(9)
out.def <- discTL(x = rock[,-ncol(rock)], y = rock[,ncol(rock)])

# show results
summary(out.def, showid = TRUE)

# usage of the method for class formula
set.seed(9)
out.frm <- discTL(formula = perm ~ ., data = rock)

# check the match of noisy indices
all(out.def$idnoise == out.frm$idnoise)

}
\references{
I. Tomek,
\strong{Two modifications of CNN.}
\emph{IEEE Trans. Syst. Man Cybern}, 6:769-772, 1976.

A. Arnaiz-González, J. Díez-Pastor, J. Rodríguez, C. García-Osorio,
\strong{Instance selection for regression by discretization.}
\emph{Expert Systems with Applications}, 54:340-350, 2016.
\doi{https://doi.org/10.1016/j.eswa.2015.12.046}.
}
\seealso{
\code{\link{discENN}}, \code{\link{discCNN}}, \code{\link{discNCL}}, \code{\link{print.rfdata}}, \code{\link{summary.rfdata}}
}
