% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportFileRepositoryListing.R
\name{exportFileRepositoryListing}
\alias{exportFileRepositoryListing}
\alias{exportFileRepositoryListing.redcapApiConnection}
\title{Export a Listing of Folders and Files in the File Repository}
\usage{
exportFileRepositoryListing(
  rcon,
  folder_id = numeric(0),
  recursive = FALSE,
  ...
)

\method{exportFileRepositoryListing}{redcapApiConnection}(
  rcon,
  folder_id = numeric(0),
  recursive = FALSE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{a \code{redcapConnection} object.}

\item{folder_id}{\code{integerish} with maximum length 1. the 
folder ID of a specific folder in the File Repository for which you 
wish to export a list of its files and sub-folders. 
By default, the top-level directory of the File Repository will be used.}

\item{recursive}{\code{logical(1)}. When \code{TRUE}, content of subfolders
will be retrieved until a full listing is produced. If \code{FALSE}, 
only the contents of the requested folder will be returned.}

\item{...}{Additional arguments to be passed between methods}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
Exports a list of folders and files saved to the file 
  repository. Includes an option to explore folders recursively.
}
\details{
This method allows you to export a list of all files and 
  sub-folders from a specific folder in a project's File Repository. 
  Each sub-folder will have an associated folder_id number, and each 
  file will have an associated doc_id number.
}
\author{
Cole Beck
}
