% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsDagMethods.R, R/exportDags.R,
%   R/importDags.R, R/deleteDags.R
\name{dagMethods}
\alias{dagMethods}
\alias{exportDags}
\alias{importDags}
\alias{deleteDags}
\alias{exportDags.redcapApiConnection}
\alias{importDags.redcapApiConnection}
\alias{deleteDags.redcapApiConnection}
\title{Export, Import, Delete Data Access Groups from a Project}
\usage{
exportDags(rcon, ...)

importDags(rcon, data, ...)

deleteDags(rcon, dags, ...)

\method{exportDags}{redcapApiConnection}(rcon, ...)

\method{importDags}{redcapApiConnection}(rcon, data, ...)

\method{deleteDags}{redcapApiConnection}(rcon, dags, ...)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{dags}{\code{character} vector of names matching the \code{unique_group_name}.}

\item{data}{A \code{data.frame} with two columns: \code{data_access_group_name}
and \code{unique_group_name}.}

\item{...}{Arguments to pass to other methods}
}
\value{
\code{exportDags} with the columns\tabular{ll}{
    \tab  \cr
   \code{data_access_group_name} \tab The human readable name for the data access group. \cr
   \code{unique_group_name} \tab The internal unique group name. \cr
   \code{data_access_group_id} \tab The internal numeric identifier. \cr
}


\code{importDags} invisibly returns the number of Data Access Groups imported.

\code{deleteDags} invisibly returns the number of Data Access Groups deleted.
}
\description{
These methods enable the user to export existing Data Access Groups,
import new Data Access Groups, or delete Data Access Groups from a
project.
}
\details{
To import new data access groups, the user must provide a value for
\code{data_access_group_name} with no value (\code{NA}) for \code{unique_group_name}.

To modify a group name, provide a new value for \code{data_access_group_name}
with the associated \code{unique_group_name}. If \code{unique_group_name}
is provided, it must match a value currently in the project.
}
\section{Functions}{
\itemize{
\item \code{exportDags()}: Export Data Access Groups from a REDCap Project

\item \code{importDags()}: Import Data Access Groups to a project.

\item \code{deleteDags()}: Delete Data Access Groups from a project.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())

exportDags(rcon)


# Import a new Data Access Group
NewData <- data.frame(data_access_group_name = "New DAG Name", 
                      unique_group_name = NA_character_)
importDags(rcon, 
           data = NewData)
           
# Modify an existing Data Access Group Name
# The user will need to match the unique_group_name to the existing DAGs
ChangeData <- data.frame(data_access_group_name = "Altered DAG Name", 
                         unique_group_name = "new_dag_name")
importDags(rcon, 
           data = ChangeData)
           
# Delete a Data Access Group
deleteDags(rcon, 
           dags = c("new_dag_name"))
}

}
\seealso{
\code{\link[=switchDag]{switchDag()}},\cr
\code{\link[=exportUserDagAssignments]{exportUserDagAssignments()}}, \cr
\code{\link[=importUserDagAssignments]{importUserDagAssignments()}}
}
