% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{spitcenter}
\alias{spitcenter}
\title{Center determination for hexahedrons}
\usage{
spitcenter(hex)
}
\arguments{
\item{hex}{dataframe with three columns and eight rows to define a hexahedron by its corner
point coordinates x, y and z}
}
\value{
vector with the spatial coordinates of the center point of the input hexahedron
}
\description{
A hexahedron is a three dimensional shape that is defined by 6 faces and 8 corner points.
\code{spitcenter} determines a center point for an input hexahedron by calculating the mean
of the maximal extent on all three axis.
}
\examples{
hexatestdf <- data.frame(
  x = c(0,1,0,4,5,5,5,5),
  y = c(1,1,4,4,1,1,4,4),
  z = c(4,8,4,9,4,8,4,6)
)

center <- spitcenter(hexatestdf)

#library(rgl)
#plot3d(
# hexatestdf$x, hexatestdf$y, hexatestdf$z,
# type = "p",
# xlab = "x", ylab = "y", zlab = "z"
#)
#plot3d(
#  center[1], center[2], center[3],
#  type = "p",
#  col = "red",
#  add = TRUE
#)

}
\seealso{
Other centerdetfuncs: \code{\link{spitcenternatlist}},
  \code{\link{spitcenternat}}
}

