% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rearrangers.R
\name{by_distance_rearranger_}
\alias{by_distance_rearranger_}
\title{Wrapper for running closest to / furthest from rearrange methods}
\usage{
by_distance_rearranger_(
  data,
  cols,
  origin = NULL,
  origin_fn = NULL,
  shuffle_ties = FALSE,
  decreasing = FALSE,
  origin_col_name = ".origin",
  distance_col_name = ".distance",
  overwrite = FALSE
)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{cols}{Column(s) to create sorting factor by.
When \code{`NULL`} and \code{`data`} is a \code{data.frame},
the row numbers are used.}

\item{origin}{Coordinates of the origin to calculate distances to.
A scalar to use in all dimensions
or a \code{vector} with one scalar per dimension.

\strong{N.B.} Ignored when \code{`origin_fn`} is not \code{`NULL`}.}

\item{origin_fn}{Function for finding the origin coordinates.

\strong{Input}: Each column will be passed as a \code{vector} in the order of \code{`cols`}.

\strong{Output}: A \code{vector} with one scalar per dimension.

Can be created with \code{\link[rearrr:create_origin_fn]{create_origin_fn()}} if you want to apply
the same function to each dimension.

E.g. \code{`create_origin_fn(median)`} would find the median of each column.

\strong{Built-in functions} are \code{\link[rearrr:centroid]{centroid()}},
\code{\link[rearrr:most_centered]{most_centered()}},
and \code{\link[rearrr:midrange]{midrange()}}}

\item{shuffle_ties}{Whether to shuffle elements with the same distance to the origin. (Logical)}

\item{decreasing}{Whether to order by decreasing distances to the origin. (Logical)}

\item{origin_col_name}{Name of new column with the origin coordinates. If \code{`NULL`}, no column is added.}

\item{distance_col_name}{Name of new column with the distances to the origin. If \code{`NULL`}, no column is added.}

\item{overwrite}{Whether to allow overwriting of existing columns. (Logical)}
}
\value{
The sorted \code{data.frame} (\code{tibble}) / \code{vector}.
}
\description{
Wrapper for running closest to / furthest from rearrange methods
}
\keyword{internal}
