% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UGMF.R
\name{UGMF}
\alias{UGMF}
\alias{dUGMF}
\alias{pUGMF}
\alias{rUGMF}
\title{Urgency Gating Model With Flip}
\usage{
dUGMF(rt, resp, phi, x_res = "default", t_res = "default")

pUGMF(rt, resp, phi, x_res = "default", t_res = "default")

rUGMF(n, phi, dt = 1e-05)
}
\arguments{
\item{rt}{vector of response times}

\item{resp}{vector of responses ("upper" and "lower")}

\item{phi}{parameter vector in the following order:
\enumerate{
\item Non-decision time (\eqn{t_{nd}}). Time for non-decision processes such as stimulus
encoding and response execution. Total decision time t is the sum of the decision
and non-decision times.
\item Relative start (\eqn{w}). Sets the start point of accumulation as a ratio of
the two decision thresholds. Related to the absolute start z point via equation
\eqn{z = b_l + w*(b_u - b_l)}.
\item Stimulus strength before the flip (\eqn{E_{01}}).
\item Stimulus strength after the flip (\eqn{E_{02}}).
\item Log10-leakage (\eqn{log_{10}(L)}). Rate of leaky integration.
\item Log10-urgency (\eqn{log_{10}(k)}). Decision urgency. If \eqn{k} is small, the choice is dominated by
leakage and approximates a LIM. If \eqn{k} is large, it is an urgency dominated decision.
\item Flip-time (\eqn{t_0}). Time when stimulus strength changes.
\item Noise scale (\eqn{\sigma}). Model scaling parameter.
\item Decision thresholds (\eqn{b}). Sets the location of each decision threshold. The
upper threshold \eqn{b_u} is above 0 and the lower threshold \eqn{b_l} is below 0 such that
\eqn{b_u = -b_l = b}. The threshold separation \eqn{a = 2b}.
\item Contamination (\eqn{g}). Sets the strength of the contamination process. Contamination
process is a uniform distribution \eqn{f_c(t)} where \eqn{f_c(t) = 1/(g_u-g_l)}
if \eqn{g_l <= t <= g_u} and \eqn{f_c(t) = 0} if \eqn{t < g_l} or \eqn{t > g_u}. It is
combined with PDF \eqn{f_i(t)} to give the final combined distribution
\eqn{f_{i,c}(t) = g*f_c(t) + (1-g)*f_i(t)}, which is then output by the program.
If \eqn{g = 0}, it just outputs \eqn{f_i(t)}.
\item Lower bound of contamination distribution (\eqn{g_l}). See parameter \eqn{g}.
\item Upper bound of contamination distribution (\eqn{g_u}). See parameter \eqn{g}.
}}

\item{x_res}{spatial/evidence resolution}

\item{t_res}{time resolution}

\item{n}{number of samples}

\item{dt}{step size of time. We recommend 0.00001 (1e-5)}
}
\value{
For the density a list of PDF values, log-PDF values, and the sum of the
log-PDFs, for the distribution function a list of of CDF values, log-CDF values,
and the sum of the log-CDFs, and for the random sampler a list of response
times (rt) and response thresholds (resp).
}
\description{
UGM with time varying drift rate. Specifically, the stimulus strength changes from
\eqn{E_{01}} to \eqn{E_{02}} at time \eqn{t_0}. Identified by (Trueblood et al., 2021) as
a way to improve recovery of the leakage rate and urgency. Drift rate becomes
\deqn{v(x,t) = E_{01}*(1 + k*t) + (k/(1+k*t) - L)*x \ \text{ if } \ t < t_0}
and
\deqn{v(x,t) = E_{02}*(1 + k*t) + (k/(1+k*t) - L)*x \ \text{ if } \ t >= t_0.}
}
\examples{
# Probability density function
dUGMF(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
      phi = c(0.3, 0.5, 1.0, 0.9, 0.5, 0.5, 0.5, 1.0, 1.5, 0.0, 0.0, 1.0))

# Cumulative distribution function
pUGMF(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
      phi = c(0.3, 0.5, 1.0, 0.9, 0.5, 0.5, 0.5, 1.0, 1.5, 0.0, 0.0, 1.0))

# Random sampling
rUGMF(n = 100, phi = c(0.3, 0.5, 1.0, 0.9, 0.5, 0.5, 0.5, 1.0, 1.5, 0.0, 0.0, 1.0))
}
\references{
Cisek, P., Puskas, G. A., & El-Murr, S. (2009). Decisions in changing conditions:
the urgency-gating model. \emph{Journal of Neuroscience, 29}(37), 11560-11571.

Trueblood, J. S., Heathcote, A., Evans, N. J., & Holmes, W. R. (2021). Urgency, leakage,
and the relative nature of information processing in decision-making.
}
\author{
Raphael Hartmann & Matthew Murrow
}
