% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotEvents.control}
\alias{plotEvents.control}
\title{Plot options for plotEvents}
\usage{
plotEvents.control(
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  terminal.name = NULL,
  recurrent.name = NULL,
  recurrent.type = NULL,
  legend.position = "top",
  base_size = 12,
  cex = NULL,
  width = NULL,
  bar.color = NULL,
  recurrent.color = NULL,
  recurrent.shape = NULL,
  recurrent.stroke = NULL,
  terminal.color = NULL,
  terminal.shape = NULL,
  terminal.stroke = NULL,
  not.terminal.color = NULL,
  not.terminal.shape = NULL,
  alpha = 0.7
)
}
\arguments{
\item{xlab}{a character string indicating the label for the x axis.
The default value is "Time".}

\item{ylab}{a character string indicating the label for the y axis.
The default value is "Subject".}

\item{main}{a character string indicating the title of the plot.}

\item{terminal.name}{a character string indicating the label for the terminal event
displayed in the legend. The default value is "Terminal event".}

\item{recurrent.name}{a character string indicating the label for the recurrent event
displayed in the legend. The default value is "Recurrent events".}

\item{recurrent.type}{a factor indicating the labels for the different recurrent event types.
This option is only available when there are more than one types of recurrent events.
The default value is "Recurrent events 1", "Recurrent events 2", ....}

\item{legend.position}{a character string specifies the position of the legend.
The available options are "none", "left", "right", "bottom", "top",
or a two-element numeric vector specifies the coordinate of the legend.
This argument is passed to the \code{ggplot} theme environment.
The default value is "top".}

\item{base_size}{a numerical value to specify the base font size, given in pts.
This argument is passed to the \code{ggplot} theme environment.
The default value is 12.}

\item{cex}{a numerical value specifies the size of the points.}

\item{width}{a numerical value specifies the width of the event plot.
By \code{ggplot} default, set to 90\% of the resolution of the data.}

\item{bar.color}{a numerical value or a character string specifies
color for lines. Default to gray.}

\item{recurrent.color}{a numerical value or a character string
specifies color for recurrent events. Default to green.}

\item{recurrent.shape}{a numerical value or a character string
specifies shape for recurrent events. Default to circle.}

\item{recurrent.stroke}{a numerical value or a character string
specifies stroke for recurrent events. Default to circle.}

\item{terminal.color}{a numerical value or a character string
specifies color for terminal events. Default to red.}

\item{terminal.shape}{a numerical value or a character string
specifies shape for terminal events. Default to triangle.}

\item{terminal.stroke}{a numerical value or a character string
specifies stroke for terminal events. Default to triangle.}

\item{not.terminal.color}{a numerical value or a character string
specifies color for non-terminal events.
Non-terminal events are not plotted at default.}

\item{not.terminal.shape}{a numerical value or a character string
specifies shape for terminal events.
Non-terminal events are not plotted at default.}

\item{alpha}{a numerical value specifies the transparency of the points.}
}
\description{
This function provides the plotting options for the \code{plotEvents()} function.
}
\seealso{
\code{\link{plotEvents}}
}
