% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_mutagenesis_search}
\alias{rba_uniprot_mutagenesis_search}
\title{Search Mutagenesis in UniProt}
\usage{
rba_uniprot_mutagenesis_search(
  accession = NULL,
  taxid = NULL,
  db_id = NULL,
  ...
)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}(s). You can supply up to 100
accession numbers.}

\item{taxid}{NIH-NCBI \href{https://www.uniprot.org/taxonomy/}{Taxon ID}.
You can supply up to 20 taxon IDs.}

\item{db_id}{The ID in a Cross-reference (external) database.
You can supply up to 20 values.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list Where each element correspond to a UniProt protein (search
 hit) and mutagenesis description are organized under the
 "features" sub-list.
}
\description{
UniProt describes the effects of mutations in proteins' amino acid
  sequence on the biological properties of the protein, cell or the
  organism. Using this function, you can search for
  \href{https://www.uniprot.org/help/mutagen}{
  mutagenesis description} in UniProt proteins.
  You may also refine your search. See "Arguments section" for more
  information.
}
\details{
Note that this is a search function. Thus, you are not required to fill
  every argument; You may use whatever combinations of arguments you see
  fit for your query.
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/mutagenesis"
}

\examples{
\donttest{
#search all mutations in COVID19 proteins
rba_uniprot_mutagenesis_search(taxid = 2697049)
}

}
\references{
\itemize{
  \item The UniProt Consortium , UniProt: the Universal Protein
  Knowledgebase in 2025, Nucleic Acids Research, 2024;, gkae1010,
  https://doi.org/10.1093/nar/gkae1010
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Mutagenesis": 
\code{\link{rba_uniprot_mutagenesis}()}
}
\concept{"UniProt - Mutagenesis"}
