/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.asm.ClassReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

class IoUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private IoUtils() {
    }

    public static ClassReader readClass(InputStream in) throws IOException {
        try {
            return new ClassReader(in);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassFormatError(e.getMessage());
        }
    }

    public static String readIntoString(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String line = null;
        while ((line = r.readLine()) != null) {
            sb.append(line).append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public static String escapeStringLiteral(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        block9: for (char ch : value.toCharArray()) {
            switch (ch) {
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    public static byte[] toByteArray(InputStream is, byte[] buf) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoUtils.pipe(is, baos, buf);
        return baos.toByteArray();
    }

    public static void pipe(InputStream is, OutputStream out, byte[] buf) throws IOException {
        int amt;
        while ((amt = is.read(buf)) >= 0) {
            out.write(buf, 0, amt);
        }
    }

    public static void runMain(Object main, String[] args, String defCommand) throws Exception {
        if (args.length > 0) {
            String command = args[0];
            Method[] methods = main.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(command)) continue;
                String[] remaining = new String[args.length - 1];
                System.arraycopy(args, 1, remaining, 0, remaining.length);
                try {
                    method.invoke(main, IoUtils.bindParameters(method, remaining));
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IllegalArgumentException) {
                        System.err.println("Syntax error: " + cause.getMessage());
                    }
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    throw e;
                }
                return;
            }
        }
        if (defCommand != null) {
            IoUtils.runMain(main, new String[]{defCommand}, null);
        }
    }

    private static Object[] bindParameters(Method method, String[] args) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int len = parameterTypes.length;
        for (int i = 0; i < len; ++i) {
            Class<?> type = parameterTypes[i];
            int remaining = Math.max(0, args.length - i);
            if (type.equals(String[].class)) {
                String[] rest = new String[remaining];
                System.arraycopy(args, 1, rest, 0, remaining);
                parameters.add(rest);
                continue;
            }
            if (remaining > 0) {
                parameters.add(IoUtils.convertParameter(args[i], parameterTypes[i]));
                continue;
            }
            parameters.add(null);
        }
        return parameters.toArray();
    }

    private static Object convertParameter(String arg, Class type) {
        if (type.equals(String.class)) {
            return arg;
        }
        if (type.equals(Integer.class)) {
            return Integer.valueOf(arg, 10);
        }
        if (type.equals(File.class)) {
            return new File(arg);
        }
        throw new UnsupportedOperationException("Unknown type " + type);
    }
}

