% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{findParent}
\alias{findParent}
\title{This function will look through a pedigree data.frame and recursively continue building that back through the history of the SHAPE run being processed.}
\usage{
findParent(func_focalGenotype, func_startStep, func_stepMatrix,
  func_progenitorList, func_demoArray, func_pedigreeAll,
  func_lineString = getOption("shape_string_lineDescent"))
}
\arguments{
\item{func_focalGenotype}{a vector of genotype IDs whose lineage you wish to identify.}

\item{func_startStep}{this is the first step in the SHAPE run from which you wish to consider re-tracing the lineage.}

\item{func_stepMatrix}{this is the matrix that represent what happened at each step in the SHAPE run.}

\item{func_progenitorList}{this is a list of the known progenitor(s) for our func_focalGenotypes}

\item{func_demoArray}{this is the whole array of step-wise SHAPE records for population demographics and feeds func_stepMatrix.}

\item{func_pedigreeAll}{this is a data.frame which contains all currently known pedigree information and informs our step-wise focus.}

\item{func_lineString}{this is the string that will be used to collapse the vector of progenitor genotype's into a single
charater string.  This collapse is done as a convenience for storage and retrieval.}
}
\value{
a vector of character strings, each of which is the found lineage of the func_focalGenotypes
}
\description{
This function will look through a pedigree data.frame and recursively continue building that back through the history of the SHAPE run being processed.
}
\section{Note}{

There is no example as this cannot work outisde of a runSHAPE call, it requires data produced by the simulation experiment.
}

