% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_traits.R
\name{get_traits}
\alias{get_traits}
\title{Get PGS Catalog Traits}
\usage{
get_traits(
  efo_id = NULL,
  trait_term = NULL,
  exact_term = TRUE,
  include_children = FALSE,
  set_operation = "union",
  interactive = TRUE,
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{efo_id}{A character vector of \href{https://www.ebi.ac.uk/efo/}{EFO}
identifiers.}

\item{trait_term}{A character vector of terms to be matched against trait
identifiers (\code{efo_id}), trait descriptions, synonyms thereof,
externally mapped terms, or even trait categories.}

\item{exact_term}{A logical value, indicating whether to match the
\code{trait_term} exactly (\code{TRUE}) or not (\code{FALSE}).}

\item{include_children}{A logical value, indicating whether to include child
traits or not.}

\item{set_operation}{Either \code{'union'} or \code{'intersection'}. This
tells how performance metrics retrieved by different criteria  should be combined:
\code{'union'} binds together all results removing duplicates and
\code{'intersection'} only keeps same sample sets found with different
criteria.}

\item{interactive}{A logical. If all traits are requested, whether to ask
interactively if we really want to proceed.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}

\item{progress_bar}{Whether to show a progress bar indicating download
progress from the REST API server.}
}
\value{
A \linkS4class{traits} object.
}
\description{
Retrieves traits via the PGS Catalog REST API. The REST
API is queried multiple times with the criteria passed as arguments (see
below). By default all traits that match the criteria supplied in the
arguments are retrieved: this corresponds to the default option
\code{set_operation} set to \code{'union'}. If you rather have only the
traits that match simultaneously all criteria provided, then set
\code{set_operation} to \code{'intersection'}.
}
\details{
Please note that all search criteria are vectorised, thus allowing for batch
mode search.
}
\examples{
\dontrun{
# Get a trait by its EFO identifier
get_traits(efo_id = 'EFO_0004631')

# Get a trait by matching a term in EFO identifier (`efo_id`), label,
# description synonyms, categories, or external mapped terms
get_traits(trait_term = 'stroke', exact_term = FALSE)

# Get a trait matching its name (`trait`) exactly (default)
get_traits(trait_term = 'stroke', exact_term = TRUE)

# Get traits, excluding its children traits (default)
get_traits(trait_term = 'breast cancer')

# Get traits, including its children traits (check column `is_child` for
# child traits)
get_traits(trait_term = 'breast cancer', include_children = TRUE)
}
}
