% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-other.R
\name{clearPlot}
\alias{clearPlot}
\alias{clearPlot,numeric,logical-method}
\alias{clearPlot,numeric,missing-method}
\alias{clearPlot,missing,logical-method}
\alias{clearPlot,missing,missing-method}
\title{Clear plotting device}
\usage{
clearPlot(
  dev = dev.cur(),
  removeData = TRUE,
  force = FALSE,
  verbose = getOption("quickPlot.verbose")
)

\S4method{clearPlot}{numeric,logical}(
  dev = dev.cur(),
  removeData = TRUE,
  force = FALSE,
  verbose = getOption("quickPlot.verbose")
)

\S4method{clearPlot}{numeric,missing}(dev, force)

\S4method{clearPlot}{missing,logical}(removeData, force)

\S4method{clearPlot}{missing,missing}(dev, removeData, force)
}
\arguments{
\item{dev}{Numeric. Device number to clear.}

\item{removeData}{Logical indicating whether any data that was stored in the
\code{.quickPlotEnv} should also be removed; i.e., not just the plot window wiped.}

\item{force}{Logical or "all". Sometimes the graphics state cannot be fixed by a simple
\code{clearPlot()}. If TRUE, this will close the device and reopen the same
device number. If "all", then all \code{quickPlot} related data from all devices
will be cleared, in addition to device closing and reopening.}

\item{verbose}{Numeric or logical. If \code{TRUE} or \verb{>0}, then messages will be
shown. If \code{FALSE} or \code{0}, most messages will be suppressed.}
}
\description{
Under some conditions, a device and its metadata need to be cleared manually.
This can be done with either the \code{new = TRUE} argument within the call to \code{Plot}.
Sometimes, the metadata of a previous plot will prevent correct plotting of
a new \code{Plot} call.
Use \code{clearPlot} to clear the device and all the associated metadata manually.
}
\examples{
if (interactive()) {
  Plot(1:10)
  clearPlot() # clears
}

}
\seealso{
\code{\link[=Plot]{Plot()}}.
}
\author{
Eliot McIntire
}
