% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{tabs}
\alias{tabs}
\title{Weighted Crossresult}
\usage{
tabs(df, x, y, type = "percent", percent = FALSE, weight = NULL,
  normwt = FALSE, na.rm = TRUE, na.show = FALSE, exclude = NULL,
  digits = 1)
}
\arguments{
\item{df}{A data.frame that contains \code{x} and (optionally) \code{y} and \code{weight}.}

\item{x}{variable name (found in \code{df}). tabs(my.data, x = 'q1').}

\item{y}{one (or more) variable names. tabs(my.data, x = 'q1', y = c('sex', 'job')).}

\item{type}{'percent' (default ranges 0-100), 'proportion', or 'counts' (type of table returned).}

\item{percent}{if \code{TRUE}, add a percent sign after the values when printing}

\item{weight}{variable name for weight (found in \code{df}).}

\item{normwt}{if TRUE, normalize weights so that the total weighted count is the same as the unweighted one}

\item{na.rm}{if TRUE, remove NA values before computation}

\item{na.show}{if TRUE, show NA count in table output}

\item{exclude}{values to remove from x and y. To exclude NA, use na.rm argument.}

\item{digits}{Number of digits to display; ?format.proptab for formatting details.}
}
\description{
Generate table with multiple weighted crossresult (full sample is first column).
kable(), which is found in library(knitr), is recommended for use with RMarkdown.
}
\details{
tabs calls wtd.table on `\code{x}` and, as applicable, each variable named by `\code{y}`.
}
\examples{
data(hdv2003) 
tabs(hdv2003, x = "relig", y = c("qualif", "trav.imp"), weight = "poids")
result <- tabs(hdv2003, x = "relig", y = c("qualif", "trav.imp"), type = "counts")
format(result, digits = 3)
# library(knitr)
# xt <- tabs(hdv2003, x = "relig", y = c("qualif", "trav.imp"), weight = "poids")
# kable(format(xt))                        # to use with RMarkdown...

}
\author{
Pete Mohanty
}
