% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_affinity.R
\name{predict.textmodel_affinity}
\alias{predict.textmodel_affinity}
\alias{coef.predict.textmodel_affinity}
\alias{residuals.predict.textmodel_affinity}
\alias{rstandard.predict.textmodel_affinity}
\title{Prediction for a fitted affinity textmodel}
\usage{
\method{predict}{textmodel_affinity}(object, newdata = NULL, level = 0.95,
  ...)

\method{coef}{predict.textmodel_affinity}(object, ...)

\method{residuals}{predict.textmodel_affinity}(object, type = c("response",
  "pearson"), ...)

\method{rstandard}{predict.textmodel_affinity}(model, ...)
}
\arguments{
\item{object}{a fitted affinity textmodel}

\item{newdata}{dfm on which prediction should be made}

\item{level}{probability level for confidence interval width}

\item{...}{unused}

\item{type}{see \link{residuals.lm}}
}
\value{
\code{predict()} returns a list of predicted affinity textmodel
  quantities.

\code{coef()} returns a document \eqn{\times} class matrix of class
  affinities for each document.

\code{residuals()} returns a document-by-feature matrix of residuals.
\code{resid()} is an alias.

\code{rstandard()} is a shortcut to return the pearson residuals.
}
\description{
Estimate \eqn{\theta_i} for each document, from a fitted
\link{textmodel_affinity} object.

Other methods below provide standard ways to extract or compute quantities 
from predicted \link{textmodel_affinity} objects.
}
\seealso{
\code{\link{influence.predict.textmodel_affinity}} for methods of
  computing the influence of particular features from a predicted
  \link{textmodel_affinity} model.
}
\keyword{internal}
\keyword{textmodel}
