% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_survey.R
\name{read_survey}
\alias{read_survey}
\title{Read a CSV file exported from Qualtrics}
\usage{
read_survey(
  file_name,
  strip_html = TRUE,
  import_id = FALSE,
  time_zone = NULL,
  legacy = FALSE,
  add_column_map = TRUE,
  add_var_labels = TRUE,
  col_types = NULL
)
}
\arguments{
\item{file_name}{String. A CSV data file.}

\item{strip_html}{Logical. If \code{TRUE}, then remove HTML tags from variable
descriptions. Defaults to \code{TRUE}.}

\item{import_id}{Logical. If \code{TRUE}, use Qualtrics import IDs instead of
question IDs as column names. Defaults to \code{FALSE}.}

\item{time_zone}{String. A local timezone to determine response date values.
Defaults to \code{NULL} which corresponds to UTC time. See \href{https://api.qualtrics.com/}{"Dates and Times"} from Qualtrics for more information on
format.}

\item{legacy}{Logical. If \code{TRUE}, then import "legacy" format CSV files (as
of 2017). Defaults to \code{FALSE}.}

\item{add_column_map}{Logical. If \code{TRUE}, then a column map data frame will
be added as an attribute to the main response data frame. This column map
captures Qualtrics-provided metadata associated with the response download,
such as an item description and internal ID's. Defaults to \code{TRUE}.}

\item{add_var_labels}{Logical. If \code{TRUE}, then the item description from each
variable (equivalent to the one in the column map) will be added as a
"label" attribute using \code{\link[sjlabelled:set_label]{sjlabelled::set_label()}}. Useful for reference as
well as cross-compatibility with other stats packages (e.g., Stata, see
documentation in \code{sjlabelled}). Defaults to \code{TRUE}.}

\item{col_types}{Optional. This argument provides a way to manually overwrite
column types that may be incorrectly guessed. Takes a \code{\link[readr:cols]{readr::cols()}}
specification. See example below and \code{\link[readr:cols]{readr::cols()}} for formatting
details. Defaults to \code{NULL}.}
}
\value{
A data frame. Variable labels are stored as attributes. They are not
printed on the console but are visibile in the RStudio viewer.
}
\description{
Reads comma separated CSV files generated by Qualtrics software. The second
line containing the variable labels is imported. Repetitive introductions to
matrix questions are automatically removed. Variable labels are stored as
attributes.
}
\examples{
\dontrun{
# Generic use of read_survey()
df <- read_survey("<YOUR-PATH-TO-CSV-FILE>")
}
# Example using current data format
file <- system.file("extdata", "sample.csv", package = "qualtRics")
df <- read_survey(file)

# Example using legacy data format
file <- system.file("extdata", "sample_legacy.csv", package = "qualtRics")
df <- read_survey(file, legacy = TRUE)

# Example changing column type
file <- system.file("extdata", "sample.csv", package = "qualtRics")
# Force EndDate to be a string
df <- read_survey(file, col_types = readr::cols(EndDate = readr::col_character()))

}
