% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualtrics_api_credentials.R
\name{qualtrics_api_credentials}
\alias{qualtrics_api_credentials}
\title{Install Qualtrics credentials in your \code{.Renviron} file for repeated use}
\usage{
qualtrics_api_credentials(
  api_key,
  base_url,
  overwrite = FALSE,
  install = FALSE,
  report = FALSE
)
}
\arguments{
\item{api_key}{The API key provided to you from Qualtrics formatted in quotes.
Learn more about Qualtrics API keys at \url{https://api.qualtrics.com/}}

\item{base_url}{The institution-specific base URL for your Qualtrics account,
formatted in quotes, without the protocol (do not include \verb{https://}). Find
your base URL at \url{https://api.qualtrics.com/}}

\item{overwrite}{If TRUE, will overwrite existing Qualtrics
credentials that you already have in your \code{.Renviron} file.}

\item{install}{If TRUE, will install the key in your \code{.Renviron} file
for use in future sessions.  Defaults to FALSE (single session use).}

\item{report}{If TRUE, ignores other arguments and outputs credentials as a
2-element named vector.}
}
\description{
This function adds your Qualtrics API key and base URL to your
\code{.Renviron} file so it can be called securely without being stored in
your code. After you have installed these two credentials, they can be
called any time with \code{Sys.getenv("QUALTRICS_API_KEY")} or
\code{Sys.getenv("QUALTRICS_BASE_URL")}. If you do not have an
\code{.Renviron} file, the function will create one for you. If you already
have an \code{.Renviron} file, the function will append the key to your
existing file, while making a backup of your original file for disaster
recovery purposes.
}
\examples{

\dontrun{
qualtrics_api_credentials(
  api_key = "<YOUR-QUALTRICS_API_KEY>",
  base_url = "<YOUR-QUALTRICS_BASE_URL>",
  install = TRUE
)
# Reload your environment so you can use the credentials without restarting R
readRenviron("~/.Renviron")
# You can check it with:
Sys.getenv("QUALTRICS_API_KEY")

# If you need to overwrite existing credentials:
qualtrics_api_credentials(
  api_key = "<YOUR-QUALTRICS_API_KEY>",
  base_url = "<YOUR-QUALTRICS_BASE_URL>",
  overwrite = TRUE,
  install = TRUE
)
# Reload your environment to use the credentials
}
}
