% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_map_gaps.R
\name{find_map_gaps}
\alias{find_map_gaps}
\title{Find gaps in a genetic map}
\usage{
find_map_gaps(map, min_gap = 50)
}
\arguments{
\item{map}{Genetic map as a list of vectors (each vector is a
chromosome and contains the marker positions).}

\item{min_gap}{Minimum gap length to return.}
}
\value{
Data frame with 6 columns: chromosome, marker to left of gap,
numeric index of marker to left, marker to right of gap, numeric
index of marker to right, and the length of the gap.
}
\description{
Find gaps between markers in a genetic map
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
find_map_gaps(iron$gmap, 40)

}
\seealso{
\code{\link[=reduce_map_gaps]{reduce_map_gaps()}}
}
